﻿using System.Net;
using System.Web.Mvc;

namespace NahrCms.Web.Helpers
{
    class PermanentRedirectResult : ActionResult
    {
        public string Url { get; set; }

        public PermanentRedirectResult(string url)
        {
            this.Url = url;
        }

        public override void ExecuteResult(ControllerContext context)
        {
            context.HttpContext.Response.StatusCode = (int)HttpStatusCode.MovedPermanently;
            context.HttpContext.Response.RedirectLocation = this.Url;
            context.HttpContext.Response.End();
        }
    }
}
