﻿using System.Web.Mvc.Html;
using System;
using System.Collections.Generic;
using System.Text;
using System.Web;
using System.Web.Mvc;
using System.Web.Routing;
using System.Linq;

namespace NahrCms.Web.Helpers
{
    public static class HtmlHelpers
    {
        public static string ClassHelper(int? order)
        {
            string orderClass = "";
            switch (order)
            {
                case 1:
                    orderClass = "one";
                    break;
                case 2:
                    orderClass = "onea";
                    break;
                case 3:
                    orderClass = "twoa";
                    break;
                case 4:
                    orderClass = "two";
                    break;
                case 5:
                    orderClass = "three";
                    break;
                case 6:
                    orderClass = "threea";
                    break;
                case 7:
                    orderClass = "foura";
                    break;
                case 8:
                    orderClass = "four";
                    break;
                case 9:
                    //orderClass = "five";
                    break;

            }
            return orderClass;
        }

        public static string ClassHelperParent(int? order)
        {
            string orderClass = "";
            switch (order)
            {
                case 9:
                    orderClass = "five";
                    break;

            }
            return orderClass;
        }

        public static string CssHelper(int? order)
        {
            return "class=hide";
        }

        /// <summary>
        /// Splits an array into several smaller arrays.
        /// </summary>
        /// <typeparam name="T">The type of the array.</typeparam>
        /// <param name="array">The array to split.</param>
        /// <param name="size">The size of the smaller arrays.</param>
        /// <returns>An array containing smaller arrays.</returns>
        public static IEnumerable<IEnumerable<T>> Split<T>(this T[] array, int size)
        {
            for (var i = 0; i < (float)array.Length / size; i++)
            {
                yield return array.Skip(i * size).Take(size);
            }
        }

        public static MvcHtmlString Script(this HtmlHelper htmlHelper, Func<object, System.Web.WebPages.HelperResult> template)
        {
            htmlHelper.ViewContext.HttpContext.Items["_script_" + System.Guid.NewGuid()] = template;
            return MvcHtmlString.Empty;
        }

        public static IHtmlString RenderScripts(this HtmlHelper htmlHelper)
        {
            foreach (object key in htmlHelper.ViewContext.HttpContext.Items.Keys)
            {
                if (key.ToString().StartsWith("_script_"))
                {
                    var template = htmlHelper.ViewContext.HttpContext.Items[key] as Func<object, System.Web.WebPages.HelperResult>;
                    if (template != null)
                    {
                        htmlHelper.ViewContext.Writer.Write(template(null));
                    }
                }
            }
            return MvcHtmlString.Empty;
        }

        public static IHtmlString Resource(this HtmlHelper HtmlHelper, Func<object, System.Web.WebPages.HelperResult> Template, string Type)
        {
            if (HtmlHelper.ViewContext.HttpContext.Items[Type] != null) ((List<Func<object, System.Web.WebPages.HelperResult>>)HtmlHelper.ViewContext.HttpContext.Items[Type]).Add(Template);
            else HtmlHelper.ViewContext.HttpContext.Items[Type] = new List<Func<object, System.Web.WebPages.HelperResult>>() { Template };

            return new HtmlString(System.String.Empty);
        }

        public static IHtmlString RenderResources(this HtmlHelper HtmlHelper, string Type)
        {
            if (HtmlHelper.ViewContext.HttpContext.Items[Type] != null)
            {
                List<Func<object, System.Web.WebPages.HelperResult>> Resources = (List<Func<object, System.Web.WebPages.HelperResult>>)HtmlHelper.ViewContext.HttpContext.Items[Type];

                foreach (var Resource in Resources)
                {
                    if (Resource != null) HtmlHelper.ViewContext.Writer.Write(Resource(null));
                }
            }

            return new HtmlString(System.String.Empty);
        }

        // <summary>Renders the collection editor for an enumerable.</summary>
        /// <typeparam name="TModel">The type of the model.</typeparam>
        /// <typeparam name="TItem">The type of the item.</typeparam>
        /// <param name="html">The HTML helper.</param>
        /// <param name="collection">The collection.</param>
        /// <param name="partialViewName">The partial name of the editor view.</param>
        /// <param name="controllerActionPath">The controller action path to generate a new item editor.</param>
        /// <param name="addButtonTitle">The title of the add button.</param>
        /// <param name="addButtonHtmlAttributes">The HTML attributes of the add button.</param>
        /// <returns>The HTML string. </returns>
        public static IHtmlString CollectionEditorFor<TModel, TItem>(this HtmlHelper<TModel> html,
            Func<TModel, IEnumerable<TItem>> collection, string partialViewName,
            string controllerActionPath, string addButtonTitle, object addButtonHtmlAttributes = null)
        {
            var editorId = "CollectionEditor_" + Guid.NewGuid().ToString("N");
            var addButtonId = "CollectionEditorAdd_" + Guid.NewGuid().ToString("N");

            var output = new StringBuilder();

            RenderInitialCollection(output, html, collection, partialViewName, editorId);
            RenderAddButton(output, addButtonId, addButtonTitle, addButtonHtmlAttributes);
            RenderEditorScript(controllerActionPath, output, editorId, addButtonId);

            return new HtmlString(output.ToString());
        }

        private static void RenderInitialCollection<TModel, TItem>(StringBuilder output, HtmlHelper<TModel> html,
            Func<TModel, IEnumerable<TItem>> collection, string partialViewName, string editorId)
        {
            output.AppendLine(@"<ul id=""" + editorId + @""" style=""list-style-type: none; padding: 0"">");
            var items = collection(html.ViewData.Model);
            if (items != null)
            {
                foreach (var item in collection(html.ViewData.Model))
                    output.AppendLine(html.Partial(partialViewName, item).ToString());
            }
            output.AppendLine(@"</ul>");
        }

        private static void RenderAddButton(StringBuilder output, string addButtonId, string addButtonTitle, object addButtonHtmlAttributes)
        {
            var inputTag = new TagBuilder("input");
            inputTag.MergeAttributes(new Dictionary<string, string>
            {
                { "type", "button" },
                { "value", addButtonTitle },
                { "id", addButtonId },
            });
            inputTag.MergeAttributes(new RouteValueDictionary(addButtonHtmlAttributes));

            output.AppendLine(@"<p>");
            output.AppendLine(inputTag.ToString());
            output.AppendLine(@"</p>");
        }

        private static void RenderEditorScript(string controllerActionPath, StringBuilder output, string editorId, string addButtonId)
        {
            output.AppendLine(
                @"<script type=""text/javascript"">
                    $(function() {
                        $(""#" + editorId + @""").sortable();
                        $(""#" + addButtonId + @""").click(function() {
                            $.get('" + controllerActionPath + @"', { '_': $.now() }, function (template) {
                                var itemList = $(""#" + editorId + @""");
                                itemList.append(template);
                                var form = itemList.closest(""form"");
                                form.removeData(""validator"");
                                form.removeData(""unobtrusiveValidation"");
                                $.validator.unobtrusive.parse(form);
                                form.validate();
                            });
                        });
                    });
                </script>");
        }

        /// <summary>Begins the rendering of collection item editor.</summary>
        /// <typeparam name="TModel">The type of the model.</typeparam>
        /// <param name="html">The HTML helper.</param>
        /// <param name="collectionPropertyName">The name of the collection property in the master view model.</param>
        /// <returns>The disposable. </returns>
        public static IDisposable BeginCollectionItem<TModel>(this HtmlHelper<TModel> html, string collectionPropertyName)
        {
            var itemIndex = GetCollectionItemIndex(collectionPropertyName);
            var collectionItemName = String.Format("{0}[{1}]", collectionPropertyName, itemIndex);

            var hiddenInput = new TagBuilder("input");
            hiddenInput.MergeAttributes(new Dictionary<string, string>
            {
                { "name", String.Format("{0}.Index", collectionPropertyName) },
                { "value", itemIndex },
                { "type", "hidden" },
                { "autocomplete", "off" }
            });

            html.ViewContext.Writer.WriteLine(hiddenInput.ToString(TagRenderMode.SelfClosing));
            return new CollectionItemNamePrefixScope(html.ViewData.TemplateInfo, collectionItemName);
        }

        private static string GetCollectionItemIndex(string collectionIndexFieldName)
        {
            var fieldKey = "MyToolkit.CollectionEditorExtensions:" + collectionIndexFieldName;
            Queue<string> previousIndices = (Queue<string>)HttpContext.Current.Items[fieldKey];

            if (previousIndices == null)
            {
                previousIndices = new Queue<string>();
                HttpContext.Current.Items[fieldKey] = new Queue<string>();

                var previousIndicesValues = HttpContext.Current.Request[collectionIndexFieldName + ".Index"];
                if (!String.IsNullOrWhiteSpace(previousIndicesValues))
                {
                    foreach (var index in previousIndicesValues.Split(','))
                        previousIndices.Enqueue(index);
                }
            }

            return previousIndices.Count > 0 ? previousIndices.Dequeue() : Guid.NewGuid().ToString();
        }

        private class CollectionItemNamePrefixScope : IDisposable
        {
            private readonly TemplateInfo _templateInfo;
            private readonly string _previousPrefix;

            public CollectionItemNamePrefixScope(TemplateInfo templateInfo, string collectionItemName)
            {
                _templateInfo = templateInfo;
                _previousPrefix = templateInfo.HtmlFieldPrefix;

                templateInfo.HtmlFieldPrefix = collectionItemName;
            }

            public void Dispose()
            {
                _templateInfo.HtmlFieldPrefix = _previousPrefix;
            }
        }

        //public static string ShowSubItems(this HtmlHelper helper, Page _object)
        //{
        //    StringBuilder output = new StringBuilder();
        //    if (_object.Page1.Count > 0)
        //    {
        //        output.Append("<ul>");

        //        foreach (Page subItem in _object.Page1)
        //        {
        //            output.Append("<li>");
        //            output.Append(_object.Title);
        //            output.Append(html.ShowSubItems(subItem.Page1);
        //            output.Append("</li>");
        //        }
        //        output.Append("</ul>");
        //    }
        //    return output.ToString();
        //}
    }



}