﻿using System;
using System.Configuration;
using System.Text;

namespace NahrCms.Web.Helpers
{
    public static class ConfigurationManagerExtension
    {
        public static string GetConfigurationValue(this String configurationkey)
        {
            return ConfigurationManager.AppSettings[configurationkey];
        }

        public static string GetConnectionStringValue(this String configurationkey)
        {
            return ConfigurationManager.ConnectionStrings[configurationkey].ConnectionString;
        }


        private readonly static string reservedCharacters = "!*'();:@&=+$,?%#[] ";
        private readonly static string reservedChar = "-";
        private readonly static string reservedBar = "|";
        public static string UrlEncode(this string value, string reolacement = "-", int Length = 1000)
        {
            if (String.IsNullOrEmpty(value))
                return String.Empty;

            var sb = new StringBuilder();

            foreach (char @char in value)
            {
                if (reservedChar.IndexOf(@char) == -1)
                    sb.Append(@char);
                else
                //sb.AppendFormat("%{0:X2}", (int)@char);
                    sb.Append("_");
            }
            return sb.ToString().Substring(0, (sb.Length > Length) ? Length : sb.Length);
        }

        public static string UrlEncodeCustom(this string value, string reolacement = "-", int Length = 1000)
        {
            if (String.IsNullOrEmpty(value))
                return String.Empty;

            var sb = new StringBuilder();

            foreach (char @char in value)
            {
                if (reservedCharacters.IndexOf(@char) == -1)
                    sb.Append(@char);
                else
                //sb.AppendFormat("%{0:X2}", (int)@char);
                    sb.Append("-");
            }
            return sb.ToString().Substring(0, (sb.Length > Length) ? Length : sb.Length);
        }

        public static string UrlEncodeVerticalBar(this string value, string reolacement = "-", int Length = 1000)
        {
            if (String.IsNullOrEmpty(value))
                return String.Empty;

            var sb = new StringBuilder();

            foreach (char @char in value)
            {
                if (reservedBar.IndexOf(@char) == -1)
                    sb.Append(@char);
                else
                //sb.AppendFormat("%{0:X2}", (int)@char);
                    sb.Append("VerticalBar");
            }
            return sb.ToString().Substring(0, (sb.Length > Length) ? Length : sb.Length);
        }

    }

//public static class ExtensionBaseResponse
//{

//    public static dynamic validateAccessToken(this BaseResponse baseResponse, string accessToken, int Role)
//    {
//        Boolean UseAuthenticationToken = Convert.ToBoolean(ConfigurationManager.AppSettings["UseAuthenticationToken"]);

//        if (UseAuthenticationToken)
//        {
//            IUserServices UserService = new UserServices();

//            if (string.IsNullOrWhiteSpace(accessToken))
//            {
//                baseResponse.responseStatus = ResponseStatus.InvalidAccessToken;
//                return baseResponse;
//            }
//            FormsAuthenticationTicket formsTicket;
//            try
//            {
//                formsTicket = FormsAuthentication.Decrypt(accessToken);
//            }
//            catch (Exception ex)
//            {
//                baseResponse.responseStatus = ResponseStatus.InvalidAccessToken;
//                return baseResponse;
//            }

//            if (formsTicket.Expired)
//            {
//                baseResponse.responseStatus = ResponseStatus.ExpiredAccessToken;
//                return baseResponse;
//            }

//            //formsTicket.Name 
//            // split the user data back apart
//            string[] userData = formsTicket.UserData.Split(new string[] { ",," }, StringSplitOptions.None);

//            int UserId = 0;
//            int userRole = 0;
//            int providerId = 0;
//            int.TryParse(userData[2], out UserId);
//            int.TryParse(userData[3], out userRole);

//            if (userData.Length > 4)
//            {
//                int.TryParse(userData[4], out providerId);
//            }

//            baseResponse.providerId = providerId;
//            if (userRole == Role || userRole == 1)
//            {
//                // var user_security_token = UserService.GetUserSecurityTokenByToken(accessToken);
//                //if (user_security_token == null || user_security_token.UserId != UserId)
//                //{
//                //    baseResponse.responseStatus = ResponseStatus.InvalidAccessToken;
//                //    return baseResponse;
//                //}

//                baseResponse.responseStatus = ResponseStatus.Success;
//                baseResponse.Token = new AccessToken() { UserID = UserId };
//                return baseResponse;
//            }
//            else
//            {
//                baseResponse.responseStatus = ResponseStatus.PermissionDenied;
//                return baseResponse;
//            }
//        }
//        else
//        {
//            baseResponse.responseStatus = ResponseStatus.Success;
//            return baseResponse;
//        }
//    }

//}
}