﻿using NahrCms.Web.Models;
using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Threading;
using System.Web;
using System.Web.SessionState;
using NahrCms.DAL;

namespace NahrCms.Web.Helpers
{
    public class CultureHelper
    {
        protected HttpSessionState session;

        //constructor   
        public CultureHelper(HttpSessionState httpSessionState)
        {
            session = httpSessionState;
        }
        // Properties   
        public static Lang CurrentCulture
        {
            get
            {
                if (Thread.CurrentThread.CurrentUICulture.Name == "en-US")
                {
                    return Lang.English;
                }
                else if (Thread.CurrentThread.CurrentUICulture.Name == "fr-FR")
                {
                    return Lang.French;
                }
                else if (Thread.CurrentThread.CurrentUICulture.Name == "nl-NL")
                {
                    return Lang.Dutch;
                }
                else
                {
                    return Lang.English;
                }
            }
            set
            {

                if (value ==  Lang.English)
                {
                    Thread.CurrentThread.CurrentUICulture = new CultureInfo("en-US");
                }
                else if (value == Lang.French)
                {
                    Thread.CurrentThread.CurrentUICulture = new CultureInfo("fr-FR");
                }
                else if (value == Lang.Dutch)
                {
                    Thread.CurrentThread.CurrentUICulture = new CultureInfo("nl-NL");
                }
                else
                {
                    Thread.CurrentThread.CurrentUICulture = new CultureInfo("en-US");
                }

                Thread.CurrentThread.CurrentCulture = Thread.CurrentThread.CurrentUICulture;

            }
        }

    }
}