﻿
var viewModel = {
    products: ko.observableArray(),
    currentPage: ko.observable(-1)
};
ko.bindingHandlers.img = {
    update: function (element, valueAccessor) {
        //grab the value of the parameters, making sure to unwrap anything that could be observable
        var value = ko.utils.unwrapObservable(valueAccessor()),
            src = ko.utils.unwrapObservable(value.src),
            fallback = ko.utils.unwrapObservable(value.fallback),
            $element = $(element);

        //now set the src attribute to either the bound or the fallback value
        if (src) {
            $element.attr("src", src);
        } else {
            $element.attr("src", fallback);
        }
    },
    init: function (element, valueAccessor) {
        var $element = $(element);

        //hook up error handling that will unwrap and set the fallback value
        $element.error(function () {
            var value = ko.utils.unwrapObservable(valueAccessor()),
                fallback = ko.utils.unwrapObservable(value.fallback);

            $element.attr("src", fallback);
        });
    },
};
ko.bindingHandlers['href'] = {
    update: function (element, valueAccessor) {
        element.href = ko.utils.unwrapObservable(valueAccessor());
    }
};
ko.bindingHandlers.trimLengthText = {};
ko.bindingHandlers.trimText = {
    init: function (element, valueAccessor, allBindingsAccessor, viewModel) {
        var trimmedText = ko.computed(function () {
            var untrimmedText = ko.utils.unwrapObservable(valueAccessor());
            var defaultMaxLength = 20;
            var minLength = 5;
            var maxLength = ko.utils.unwrapObservable(allBindingsAccessor().trimTextLength) || defaultMaxLength;
            if (maxLength < minLength) maxLength = minLength;
            var text = untrimmedText.length > maxLength ? untrimmedText.substring(0, maxLength - 1) + '...' : untrimmedText;
            return text;
        });
        ko.applyBindingsToNode(element, {
            text: trimmedText
        }, viewModel);

        return {
            controlsDescendantBindings: true
        };
    }
};
var $select = $('#ProductCategoryList');
// update the ViewModel value on change

$select.change(function () {
    viewModel.products([]);
    viewModel.currentPage = ko.observable(-1);
    self.viewModel.products.valueHasMutated();
    getData(viewModel.currentPage() + 1, $select.val());
    ko.applyBindings(viewModel, document.getElementById('sub-content'));
});
$(document).ready(function () {

    //getData(viewModel.currentPage() + 1, $('#ProjectCategoryList').val());
    getData(viewModel.currentPage() + 1, $('#ProductCategoryList').val());
    $(window).scroll(function (evt) {
        evt.preventDefault();
        if ($(window).scrollTop() >= $(document).height() - $(window).height()) {
            //console.log("Scroll Postion" + $(window).scrollTop());
            getData(viewModel.currentPage() + 1, $('#ProductCategoryList').val());
        }
    });
    ko.applyBindings(viewModel, document.getElementById('sub-content'));
});

function getData(pageNumber, categoryId) {
    if (viewModel.currentPage() != pageNumber) {
        //console.log("Scroll Postion begin getData" + $(window).scrollTop());
        $.ajax({
            url: "http://localhost:62772/en/api/product/web/getall",
            //url: "http://nahrcms.nahrdev.net/en/api/product/web/getall",
            type: "get",
            contentType: "application/json",
            data: { id: pageNumber, categoryId: categoryId }
        }).done(function (data) {
            if (data.length > 0) {
                viewModel.currentPage(viewModel.currentPage() + 1);
                for (i = 0; i < data.length; i++) {
                    viewModel.products.push(data[i]);
                    //console.log("Scroll Postion looping ViewModel" + $(window).scrollTop());
                }

            }
        });

    }
}

