﻿var viewModel = {
	news: ko.observableArray(),
	currentPage: ko.observable(-1)
};
ko.bindingHandlers.img = {
	update: function (element, valueAccessor) {
		//grab the value of the parameters, making sure to unwrap anything that could be observable
		var value = ko.utils.unwrapObservable(valueAccessor()),
            src = ko.utils.unwrapObservable(value.src),
            fallback = ko.utils.unwrapObservable(value.fallback),
            $element = $(element);

		//now set the src attribute to either the bound or the fallback value
		if (src) {
			$element.attr("src", src);
		} else {
			$element.attr("src", fallback);
		}
	},
	init: function (element, valueAccessor) {
		var $element = $(element);

		//hook up error handling that will unwrap and set the fallback value
		$element.error(function () {
			var value = ko.utils.unwrapObservable(valueAccessor()),
                fallback = ko.utils.unwrapObservable(value.fallback);

			$element.attr("src", fallback);
		});
	},
};
ko.bindingHandlers['href'] = {
	update: function (element, valueAccessor) {
		element.href = ko.utils.unwrapObservable(valueAccessor());
	}
};
ko.bindingHandlers.trimLengthText = {};
ko.bindingHandlers.trimText = {
	init: function (element, valueAccessor, allBindingsAccessor, viewModel) {
		var trimmedText = ko.computed(function () {
			var untrimmedText = ko.utils.unwrapObservable(valueAccessor());
			var defaultMaxLength = 20;
			var minLength = 5;
			var maxLength = ko.utils.unwrapObservable(allBindingsAccessor().trimTextLength) || defaultMaxLength;
			if (maxLength < minLength) maxLength = minLength;
			var text = untrimmedText.length > maxLength ? untrimmedText.substring(0, maxLength - 1) + '...' : untrimmedText;
			return text;
		});
		ko.applyBindingsToNode(element, {
			html: trimmedText
		}, viewModel);

		return {
			controlsDescendantBindings: true
		};
	}
};

$(document).ready(function () {
	getData(viewModel.currentPage() + 1);
	$(window).scroll(function (evt) {
		evt.preventDefault();
		if ($(window).scrollTop() >= $(document).height() - $(window).height()) {
			console.log("Scroll Postion" + $(window).scrollTop());
			getData(viewModel.currentPage() + 1);
		}
	});
	ko.applyBindings(viewModel, document.getElementById('sub-content'));
});

function getData(pageNumber) {
	if (viewModel.currentPage() != pageNumber) {
		console.log("Scroll Postion begin getData" + $(window).scrollTop());
		$.ajax({
		    url: "http://localhost:62772/en/api/news/web/getall",
		   // url: "http://nahrcms.nahrdev.net/en/api/news/web/getmenu",
			type: "get",
			contentType: "application/json",
			data: { id: pageNumber}
		}).done(function (data) {
			if (data.length > 0) {
				viewModel.currentPage(viewModel.currentPage() + 1);
				for (i = 0; i < data.length; i++) {
				    viewModel.news.push(data[i]);
					console.log("Scroll Postion looping ViewModel" + $(window).scrollTop());
				}

			}
		});

	}
}