﻿
function getNestedMenu(index, all) {

    var root = all[index];

    if (!root) {
        return all;
    }

    if (!all[index].children) {
        all[index].children = [];
    }

    for (var i = 0; i < all.length; i++) {
        //<infinity nesting?>

        //put children inside it's parent
        if (all[index].id == all[i].parentId) {
            all[index].children.push(all[i]);
            all[i].used = true;
        }

        //this is needed for each item, to determine which template to use        
        all[index].nodeTemplate = function (node) {
            return node.children.length > 0 ? 'nodeTempl' : 'nodeLeafTempl';
        }
        //</infinity nesting?>
    }

    return getNestedMenu(++index, all);
};

function getModel(data) {
    var items = getNestedMenu(0, data);

    //<remove duplicates, for infinity nesting only>   
    for (var i = 0; i < items.length; i++) {
        if (items[i].used) {
            items.splice(i, 1);
            i--;
        }
    }
    //</remove duplicates, for infinity nesting only>
    //<build root item>
    var model = {};
    model.children = ko.observableArray(items);
    model.nodeTemplate = function (node) {
        return node.children.length > 0 ? 'nodeTempl' : 'nodeLeafTempl';
    }
    //</build root item>
    console.log(items);
    return model;
};


(function () {
    $.ajax({
        type: "GET",
        url: "http://localhost:62772/en/api/home/web/getmenu",
        //url: "http://nahrcms.nahrdev.net/en/api/home/web/getmenu",
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        success: function (data) {
            ko.applyBindings(getModel(data));
        },
        error: function (error) {
            alert(error.status + "<--and--> " + error.statusText);
        }
    });
    
})();