﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using NahrCms.DAL;
using NahrCms.Web.Areas.admin.Controllers;
using NahrCms.Web.Areas.admin.DataModels.Models.Content;
using NahrCms.Web.Areas.admin.DataModels.Models.PhotoGallery;
using NahrCms.Web.Areas.en.Models;
using NahrCms.Web.Helpers;
using NahrCms.Web.Models;

namespace NahrCms.Web.Areas.en.Controllers
{
    public class SupportsController : BaseController
    {
        // GET: en/Supports
        public ActionResult Index()
        {
            ContactUsModel model = new ContactUsModel();
            model.listOfSupportModel = new List<SupportModel>();
            Setting objsetting = context.Settings.Where(x => x.Id == 1).SingleOrDefault();
            model.facebookURL = objsetting.FaceBookURL;
            model.twitterURL = objsetting.TwitterURL;
            model.googleURL = objsetting.GoogleURL;
            model.address = objsetting.Address;
            model.contactMail = objsetting.Email;
            model.Photo = objsetting.Image;
            model.ENCompanyName = objsetting.EnCompanyName;
            if (objsetting.ShowAboutUs != null)
                model.ShowAboutUs = objsetting.ShowAboutUs.Value;
            if (objsetting.ShowContactUs != null)
                model.ShowContactus = objsetting.ShowContactUs.Value;
            if (objsetting.ShowEvents != null)
                model.ShowEvents = objsetting.ShowEvents.Value;
            if (objsetting.ShowMission != null)
                model.ShowMission = objsetting.ShowMission.Value;
            if (objsetting.ShowNews != null)
                model.ShowNews = objsetting.ShowNews.Value;
            if (objsetting.ShowProduct != null)
                model.ShowProducts = objsetting.ShowProduct.Value;
            if (objsetting.ShowProject != null)
                model.ShowProjects = objsetting.ShowProject.Value;
            if (objsetting.ShowShowRooms != null)
                model.ShowShowRooms = objsetting.ShowShowRooms.Value;
            if (objsetting.ShowSlider != null)
                model.ShowSlider = objsetting.ShowSlider.Value;
            if (objsetting.MaterialMenu != null)
                model.MaterialsMenu = objsetting.MaterialMenu.Value;
            if (objsetting.EventMenu != null)
                model.EventsMenu = objsetting.EventMenu.Value;
            if (objsetting.ProjectMenu != null)
                model.ProjectMenu = objsetting.ProjectMenu.Value;
            if (objsetting.ProductMenu != null)
                model.ProductMenu = objsetting.ProductMenu.Value;
            if (objsetting.ShowRoomsMenu != null)
                model.ShowRoomsMenu = objsetting.ShowRoomsMenu.Value;
            if (objsetting.GalleryMenu != null)
                model.GalleryMenu = objsetting.GalleryMenu.Value;
            if (objsetting.NewsMenu != null)
                model.NewsMenu = objsetting.NewsMenu.Value;

            model.listOfSupportModel = context.Supports.Select(c => new SupportModel()
            {
                Id = c.Id,
                Title = CultureHelper.CurrentCulture == Lang.English ? c.TitleEn : CultureHelper.CurrentCulture == Lang.French ? c.TitleFr : c.TitleNl,
                Description = CultureHelper.CurrentCulture == Lang.English ? c.Description : CultureHelper.CurrentCulture == Lang.French ? c.DescriptionFr : c.DescriptionNl,
            }).ToList();

            //Common Support Questions
            var quality4 = context.News.Where(c => c.Id == 42).FirstOrDefault();
            model.newsmodel.qualityTitle4 = CultureHelper.CurrentCulture == Lang.English ? quality4.Title : CultureHelper.CurrentCulture == Lang.French ? quality4.TitleFr : quality4.TitleNl;
            model.newsmodel.qualityDecrition4 = CultureHelper.CurrentCulture == Lang.English ? quality4.Description : CultureHelper.CurrentCulture == Lang.French ? quality4.DescriptionFr : quality4.DescriptionNl;
            return View("index",model);
        }
         
        public ActionResult List(SupportModel model)
        {

           
            Setting settingobj = context.Settings.Where(x => x.Id == 1).FirstOrDefault();
            model.ENCompanyName = settingobj.EnCompanyName;
            model.Photo = settingobj.Image;
            if (settingobj.MaterialMenu != null)
                model.MaterialsMenu = settingobj.MaterialMenu.Value;
            if (settingobj.EventMenu != null)
                model.EventsMenu = settingobj.EventMenu.Value;
            if (settingobj.ProjectMenu != null)
                model.ProjectMenu = settingobj.ProjectMenu.Value;
            if (settingobj.ProductMenu != null)
                model.ProductMenu = settingobj.ProductMenu.Value;
            if (settingobj.ShowRoomsMenu != null)
                model.ShowRoomsMenu = settingobj.ShowRoomsMenu.Value;
            if (settingobj.GalleryMenu != null)
                model.GalleryMenu = settingobj.GalleryMenu.Value;
            if (settingobj.NewsMenu != null)
                model.NewsMenu = settingobj.NewsMenu.Value;
            return View(model);

        }

        public ActionResult Details(string Title, NewsModel model)
        {

            var obj = context.News.Where(x => x.Title.Replace(" ", "-") == Title).FirstOrDefault();
            Setting settingobj = context.Settings.Where(x => x.Id == 1).FirstOrDefault();
            model.Header_Image = settingobj.Header_Photo;
            model.ENCompanyName = settingobj.EnCompanyName;
            model.Photo = settingobj.Image;
            if (settingobj.MaterialMenu != null)
                model.MaterialsMenu = settingobj.MaterialMenu.Value;
            if (settingobj.EventMenu != null)
                model.EventsMenu = settingobj.EventMenu.Value;
            if (settingobj.ProjectMenu != null)
                model.ProjectMenu = settingobj.ProjectMenu.Value;
            if (settingobj.ProductMenu != null)
                model.ProductMenu = settingobj.ProductMenu.Value;
            if (settingobj.ShowRoomsMenu != null)
                model.ShowRoomsMenu = settingobj.ShowRoomsMenu.Value;
            if (settingobj.GalleryMenu != null)
                model.GalleryMenu = settingobj.GalleryMenu.Value;
            if (settingobj.NewsMenu != null)
                model.NewsMenu = settingobj.NewsMenu.Value;
            model.Title = obj.Title;
            model.Description = obj.Description;
            model.MainPhoto = obj.Image;
            model.Date = obj.Date;

            return View(model);
        }
    }
}