﻿using NahrCms.DAL;
using NahrCms.Web.Areas.admin.DataModels.Models.Configuration;
using NahrCms.Web.Helpers;
using NahrCms.Web.Models;
using System.Linq;
using System.Web.Mvc;

namespace NahrCms.Web.Areas.en.Controllers
{
    public class RotatorController : Controller
    {
        NahrCmsAppEntities context = new NahrCmsAppEntities();
        // GET: en/Rotator
        public ActionResult Index()
        {
            return View();
        }

        public ActionResult HomePage()
        {
            SliderModel model = new SliderModel();
            model.SliderItems = context.Rotators.OrderBy(x=>x.Order).Select(c => new SliderModel()
                {
                    Id = c.Id,
                    Title = CultureHelper.CurrentCulture == Lang.English? c.Title: CultureHelper.CurrentCulture == Lang.French? c.TitleFr : c.TitleNl,
                    Image = c.Photo,
                    Link = c.Link,
                    YoutubeLink = c.YoutubeLink
                }).ToList();
            return PartialView("_HomePage",model);
        }
    }
}