﻿using NahrCms.DAL;
using NahrCms.Web.Areas.admin.Controllers;
using NahrCms.Web.Areas.admin.DataModels.Models.FrameWorkModels;
using NahrCms.Web.Areas.admin.DataModels.Models.Projects;
using System.Collections.Generic;
using System.Linq;
using System.Web.Mvc;


namespace NahrCms.Web.Areas.en.Controllers
{
    public class ProjectController : BaseController
    {
        public ActionResult Index()
        {
            return View();
        }
        public ActionResult HomePage()
        {
            ProjectModel model = new ProjectModel();
            model.PojectCategoryItems = context.ProjectCategories.Select(x => new ProjectModel()
            {
                Id = x.Id,
                Title = x.Title,

            }).ToList();

            model.PojectItems = context.Projects.Where(x => x.Featured == true).Select(c => new ProjectModel()
            {
                Id = c.Id,
                Title = c.Title,
                MainPhoto = c.MainImage,
                ProjectCategoryId = c.CategoryId,

            }).Take(8).ToList();
            return PartialView("_HomePage", model);
        }

        public ActionResult List(ProjectModel model)
        {
            Setting obj = context.Settings.Where(x => x.Id == 1).FirstOrDefault();
            model.Header_Image = obj.Header_Photo;
            model.Footer_Image = obj.Project_Footer;
            model.ENCompanyName = obj.EnCompanyName;
            model.Photo = obj.Image;
            if (obj.MaterialMenu != null)
                model.MaterialsMenu = obj.MaterialMenu.Value;
            if (obj.EventMenu != null)
                model.EventsMenu = obj.EventMenu.Value;
            if (obj.ProjectMenu != null)
                model.ProjectMenu = obj.ProjectMenu.Value;
            if (obj.ProductMenu != null)
                model.ProductMenu = obj.ProductMenu.Value;
            if (obj.ShowRoomsMenu != null)
                model.ShowRoomsMenu = obj.ShowRoomsMenu.Value;
            if (obj.GalleryMenu != null)
                model.GalleryMenu = obj.GalleryMenu.Value;
            if (obj.NewsMenu != null)
                model.NewsMenu = obj.NewsMenu.Value;
            FilterModel(model);
            return View(model);
        }

        private void FilterModel(ProjectModel model)
        {
            var langs = from c in context.ProjectCategories.ToList()
                        select new BaseObject() { Id = c.Id, Category = c.Title };
            model.ProjectCategoryList = new List<BaseObject>();
            model.ProjectCategoryList.Add(new BaseObject() { Id = null, Category = "Select Category" });
            model.ProjectCategoryList.AddRange(langs.ToList());
        }

        public ActionResult Details(string Title, ProjectModel model)
        {

            var obj = context.Projects.Where(x => x.Title.Replace(" ","-") == Title).FirstOrDefault();
            Setting settingobj = context.Settings.Where(x => x.Id == 1).FirstOrDefault();
            model.Header_Image = settingobj.Header_Photo;
            model.Footer_Image = settingobj.Project_Footer;
            model.ENCompanyName = settingobj.EnCompanyName;
            model.Photo = settingobj.Image;
            if (settingobj.MaterialMenu != null)
                model.MaterialsMenu = settingobj.MaterialMenu.Value;
            if (settingobj.EventMenu != null)
                model.EventsMenu = settingobj.EventMenu.Value;
            if (settingobj.ProjectMenu != null)
                model.ProjectMenu = settingobj.ProjectMenu.Value;
            if (settingobj.ProductMenu != null)
                model.ProductMenu = settingobj.ProductMenu.Value;
            if (settingobj.ShowRoomsMenu != null)
                model.ShowRoomsMenu = settingobj.ShowRoomsMenu.Value;
            if (settingobj.GalleryMenu != null)
                model.GalleryMenu = settingobj.GalleryMenu.Value;
            if (settingobj.NewsMenu != null)
                model.NewsMenu = settingobj.NewsMenu.Value;
            model.Title = obj.Title;
            model.Description = obj.Description;
            model.MainPhoto = obj.MainImage;
            model.YouTubeLink = obj.YoutubeLink;
            if (obj.PhotoGallery != null)
                model.PhotosUpload = obj.PhotoGallery.Split(',').ToList();

            return View(model);
        }
    }
}