﻿using NahrCms.Web.Areas.admin.Controllers;
using NahrCms.Web.Areas.admin.DataModels.Models.Products;
using System.Collections.Generic;
using System.Linq;
using System.Web.Mvc;
using NahrCms.Web.Areas.admin.DataModels.Models.FrameWorkModels;
using NahrCms.DAL;
using NahrCms.Web.Areas.en.Models;
using NahrCms.Web.Areas.admin.DataModels.Models.Projects;
using System.IO;
using System.Net.Mail;
using System;
using System.Text;
using NahrCms.Web.Helpers;
using NahrCms.Web.Models;

namespace NahrCms.Web.Areas.en.Controllers
{
    public class ProductsController : BaseController
    {
        public PartialViewResult _PopInquiryar()
        {
            ProductModel model = new ProductModel();
            model.productList.Add(new SelectListItem { Value = "تطبيق هذا المنتج", Text = "تطبيق هذا المنتج" });
            model.productList = context.Products.Select(v => new SelectListItem { Text = CultureHelper.CurrentCulture == Lang.English?
                v.Title: CultureHelper.CurrentCulture == Lang.French?v.TitleFr:v.TitleNl, Value = CultureHelper.CurrentCulture == Lang.English ? v.Title : CultureHelper.CurrentCulture == Lang.French ? v.TitleFr:v.TitleNl}).ToList();
            return PartialView(model);
        }
        public PartialViewResult _PopInquiry()
        {
            ProductModel model = new ProductModel();
            model.productList.Add(new SelectListItem { Value = "Application of this product", Text = "Application of this product" });
            model.productList = context.Products.Select(v => new SelectListItem { Text = v.Title, Value = v.Title }).ToList();
                return PartialView(model);
        }
        [HttpPost]
        public JsonResult sendToEmail(string CompanyNameh, string Companyactivity, string Adressh, string countryen, string Telephoneh,
            string Website, string Namehen, string Title, string Telephonemobile
            , string Quantityrequired, string Destination, string Shipmentterms, string Packingen, string Applicationen
            ,string Email)
        {
            Setting obj = context.Settings.Where(x => x.Id == 1).SingleOrDefault();
            if (ModelState.IsValid)
            {
                try
                {
                    System.Net.Mail.MailMessage msg = new System.Net.Mail.MailMessage();
                    SmtpClient smtp = new SmtpClient("" + obj.SMTP + "");
                    MailAddress from = new MailAddress(obj.Email);
                    StringBuilder sb = new StringBuilder();
                    msg.From = new MailAddress("sales@BMS.com", CompanyNameh);// replace it with sender email address
                    msg.To.Add(new MailAddress("sales@BMS.com"));
                    msg.Subject = "Inquiry for product";
                    smtp.EnableSsl = true;
                    smtp.UseDefaultCredentials = false;
                    smtp.DeliveryMethod = SmtpDeliveryMethod.Network;
                    smtp.Credentials = new System.Net.NetworkCredential(obj.Email, obj.Password);
                    smtp.Port = 587;
                    sb.Append("Company Name: " + CompanyNameh);
                    sb.Append(Environment.NewLine);
                    sb.Append("Company activity: " + Companyactivity);
                    sb.Append(Environment.NewLine);
                    sb.Append("Adress: " + Adressh);
                    sb.Append(Environment.NewLine);
                    sb.Append("Country: " + countryen);
                    sb.Append(Environment.NewLine);
                    sb.Append("Telephone: " + Telephoneh);
                    sb.Append(Environment.NewLine);
                    sb.Append("Website: " + Website);
                    sb.Append(Environment.NewLine);
                    sb.Append("Contact person name: " + Namehen);
                    sb.Append(Environment.NewLine);
                    sb.Append("Email: " + Email);
                    sb.Append(Environment.NewLine);
                    sb.Append("Title: " + Title);
                    sb.Append(Environment.NewLine);
                    sb.Append("Telephone , mobile number: " + Telephonemobile);
                    sb.Append(Environment.NewLine);
                    sb.Append("Quantity required: " + Quantityrequired );
                    sb.Append(Environment.NewLine);
                    sb.Append("Packing: " + Packingen);
                    sb.Append(Environment.NewLine);
                    sb.Append("Destination: " + Destination);
                    sb.Append(Environment.NewLine);
                    sb.Append("Shipment terms: " + Shipmentterms);
                    sb.Append(Environment.NewLine);
                    sb.Append("Application of this product: " + Applicationen);
                    msg.Body = sb.ToString();
                    smtp.Send(msg);
                    msg.Dispose();
                    //TempData["alertMessage"] = "Thank You For Your Message";

                    return Json(new { success = true, message = "" });
                }
                catch (Exception ex)
                {
                    return Json(new { success = false, message = "" });
                }
            }
            return Json(new { success = true, message = "" });
        } 
        public ActionResult Index()
        {
            ContactUsModel model = new ContactUsModel();

            model.listOfCategory = context.ProductCategories.Select(c => new ProductCategoryModel()
            {
                Id = c.Id,
                Title = c.Title,
                TitleFr = c.TitleFr,
                TitleNl = c.TitleNl,
                Description = c.Description,
                DescriptionFr = c.DescriptionFr,
                DescriptionNl = c.DescriptionNl,
            }).ToList();

            model.products = context.Products.Select(c => new ProductModel()
            {
                Id = c.Id,
                MainPhoto = c.MainImage,
                ProductCategoryId = c.CategoryId,
                Title = CultureHelper.CurrentCulture == Lang.English ? c.Title : CultureHelper.CurrentCulture == Lang.French ? c.TitleFr : c.TitleNl, 
                Description = CultureHelper.CurrentCulture == Lang.English ? c.Description : CultureHelper.CurrentCulture == Lang.French ? c.DescriptionFr : c.DescriptionNl, 
            }).ToList();

            Setting objsetting = context.Settings.Where(x => x.Id == 1).SingleOrDefault();
            model.facebookURL = objsetting.FaceBookURL;
            model.twitterURL = objsetting.TwitterURL;
            model.googleURL = objsetting.GoogleURL;
            model.address = objsetting.Address;
            model.contactMail = objsetting.Email;
            model.Photo = objsetting.Image;
            model.ENCompanyName = objsetting.EnCompanyName;
            if (objsetting.ShowAboutUs != null)
                model.ShowAboutUs = objsetting.ShowAboutUs.Value;
            if (objsetting.ShowContactUs != null)
                model.ShowContactus = objsetting.ShowContactUs.Value;
            if (objsetting.ShowEvents != null)
                model.ShowEvents = objsetting.ShowEvents.Value;
            if (objsetting.ShowMission != null)
                model.ShowMission = objsetting.ShowMission.Value;
            if (objsetting.ShowNews != null)
                model.ShowNews = objsetting.ShowNews.Value;
            if (objsetting.ShowProduct != null)
                model.ShowProducts = objsetting.ShowProduct.Value;
            if (objsetting.ShowProject != null)
                model.ShowProjects = objsetting.ShowProject.Value;
            if (objsetting.ShowShowRooms != null)
                model.ShowShowRooms = objsetting.ShowShowRooms.Value;
            if (objsetting.ShowSlider != null)
                model.ShowSlider = objsetting.ShowSlider.Value;
            if (objsetting.MaterialMenu != null)
                model.MaterialsMenu = objsetting.MaterialMenu.Value;
            if (objsetting.EventMenu != null)
                model.EventsMenu = objsetting.EventMenu.Value;
            if (objsetting.ProjectMenu != null)
                model.ProjectMenu = objsetting.ProjectMenu.Value;
            if (objsetting.ProductMenu != null)
                model.ProductMenu = objsetting.ProductMenu.Value;
            if (objsetting.ShowRoomsMenu != null)
                model.ShowRoomsMenu = objsetting.ShowRoomsMenu.Value;
            if (objsetting.GalleryMenu != null)
                model.GalleryMenu = objsetting.GalleryMenu.Value;
            if (objsetting.NewsMenu != null)
                model.NewsMenu = objsetting.NewsMenu.Value;
            return PartialView("Index", model);
        }
        public ActionResult List(int? page, ProductModel model, string Category)
        {
            Setting obj = context.Settings.Where(x => x.Id == 1).FirstOrDefault();
            model.Header_Image = obj.Header_Photo;
            model.Footer_Image = obj.Product_Footer;
            model.ENCompanyName = obj.EnCompanyName;
            model.Photo = obj.Image;
            if (obj.MaterialMenu != null)
                model.MaterialsMenu = obj.MaterialMenu.Value;
            if (obj.EventMenu != null)
                model.EventsMenu = obj.EventMenu.Value;
            if (obj.ProjectMenu != null)
                model.ProjectMenu = obj.ProjectMenu.Value;
            if (obj.ProductMenu != null)
                model.ProductMenu = obj.ProductMenu.Value;
            if (obj.ShowRoomsMenu != null)
                model.ShowRoomsMenu = obj.ShowRoomsMenu.Value;
            if (obj.GalleryMenu != null)
                model.GalleryMenu = obj.GalleryMenu.Value;
            if (obj.NewsMenu != null)
                model.NewsMenu = obj.NewsMenu.Value;
            FilterModel(model);
            return View(model);
        }
        public ActionResult HomePageSecondSection()
        {
            ProductModel model = new ProductModel();
            model.ProductCategoryItems = context.ProjectCategories.Select(x => new ProductModel()
            {
                Id = x.Id,
                Title = x.Title,

            }).ToList();

            //model.ProductItems = context.Products.Where(d=>d.Featured).Select(c => new ProductModel()
            //{
            //    Id = c.Id,
            //    Title = c.Title,
            //    MainPhoto = c.MainImage,
            //    ProductCategoryId = c.CategoryId,

            //}).Take(3).ToList();
            return PartialView("_HomePageSecondSection", model);
        }
        public ActionResult HomePage()
        {
            ProductModel model = new ProductModel();
            model.ProductCategoryItems = context.ProjectCategories.Select(x => new ProductModel()
            {
                Id = x.Id,
                Title = x.Title,

            }).ToList();

            //var item1 = context.Products.Select(c => new productRequred(){Id = c.Id,Title = c.Title,MainPhoto = c.MainImage}).Where(c => c.Id == 1).FirstOrDefault();
            //var item2 = context.Products.Select(c => new productRequred(){Id = c.Id,Title = c.Title,MainPhoto = c.MainImage}).Where(c => c.Id == 13).FirstOrDefault();
            //var item3 = context.Products.Select(c => new productRequred(){Id = c.Id,Title = c.Title,MainPhoto = c.MainImage}).Where(c => c.Id == 14).FirstOrDefault();
            //var item4 = context.Products.Select(c => new productRequred(){Id = c.Id,Title = c.Title,MainPhoto = c.MainImage}).Where(c => c.Id == 15).FirstOrDefault();
            //var item5 = context.Products.Select(c => new productRequred(){Id = c.Id,Title = c.Title,MainPhoto = c.MainImage}).Where(c => c.Id == 16).FirstOrDefault();
            //var item6 = context.Products.Select(c => new productRequred(){Id = c.Id,Title = c.Title,MainPhoto = c.MainImage}).Where(c => c.Id == 17).FirstOrDefault();
            //var item7 = context.Products.Select(c => new productRequred(){Id = c.Id, Title = c.Title,MainPhoto = c.MainImage}).Where(c => c.Id == 18).FirstOrDefault();
            //var item8 = context.Products.Select(c => new productRequred(){Id = c.Id,Title = c.Title,MainPhoto = c.MainImage}).Where(c => c.Id == 19).FirstOrDefault();
            //model.ProductItems.Add(item1);
            //model.ProductItems.Add(item2);
            //model.ProductItems.Add(item3);
            //model.ProductItems.Add(item4);
            //model.ProductItems.Add(item5);
            //model.ProductItems.Add(item6);
            //model.ProductItems.Add(item7);
            //model.ProductItems.Add(item8);
            return PartialView("_HomePage", model.ProductItems);
        }

        private void FilterModel(ProductModel model)
        {
            var langs = from c in context.ProductCategories.ToList()
                        select new BaseObject() { Id = c.Id, Category = c.Title };
            model.ProductCategoryList = new List<BaseObject>();
            model.ProductCategoryList.Add(new BaseObject() { Id = null, Category = "Select Category" });
            model.ProductCategoryList.AddRange(langs.ToList());
        }

        public ActionResult Details(string Title, ProductModel model)
        {
            var obj = context.Products.Where(x =>  x.Title.Replace(" ", "-") == Title).FirstOrDefault();

            Setting settingobj = context.Settings.Where(x => x.Id == 1).FirstOrDefault();
            model.Header_Image = settingobj.Header_Photo;
            model.Footer_Image = settingobj.Product_Footer;
            model.ENCompanyName = settingobj.EnCompanyName;
            model.Photo = settingobj.Image;
            if (settingobj.MaterialMenu != null)
                model.MaterialsMenu = settingobj.MaterialMenu.Value;
            if (settingobj.EventMenu != null)
                model.EventsMenu = settingobj.EventMenu.Value;
            if (settingobj.ProjectMenu != null)
                model.ProjectMenu = settingobj.ProjectMenu.Value;
            if (settingobj.ProductMenu != null)
                model.ProductMenu = settingobj.ProductMenu.Value;
            if (settingobj.ShowRoomsMenu != null)
                model.ShowRoomsMenu = settingobj.ShowRoomsMenu.Value;
            if (settingobj.GalleryMenu != null)
                model.GalleryMenu = settingobj.GalleryMenu.Value;
            if (settingobj.NewsMenu != null)
                model.NewsMenu = settingobj.NewsMenu.Value;
            model.Title = obj.Title;
            model.Description = obj.Description;
            model.MainPhoto = obj.MainImage;
            model.ProductCategory = obj.ProductCategory.Title;
            if (obj.PhotoGallery != null)
                model.PhotosUpload = obj.PhotoGallery.Split(',').ToList();

            return View(model);
        }
        [HttpPost]
        public JsonResult ChangeCategory(int CateoryId)
        {
            ContactUsModel model = new ContactUsModel();
            var listJobs = from pro in context.Products
                           where pro.CategoryId == CateoryId
                           select pro;
            model.products = listJobs.Select(v => new ProductModel()
            {
                Title = CultureHelper.CurrentCulture == Lang.English ? v.Title : CultureHelper.CurrentCulture == Lang.French ? v.TitleFr : v.TitleNl, 
                Description = CultureHelper.CurrentCulture == Lang.English ? v.Description : CultureHelper.CurrentCulture == Lang.French ? v.DescriptionFr : v.DescriptionNl, 
                MainPhoto = v.MainImage
            }).ToList();
            var ListJobshtml = RenderPartialViewToString("_ProductItem", model);
            return Json(new
            {
                success = true,
                ListJobshtml = ListJobshtml
            });
        }
        [HttpPost]
        public JsonResult ChangeCategoryAr(int CateoryId)
        {
            ContactUsModel model = new ContactUsModel();
            var listJobs = from pro in context.Products
                           where pro.CategoryId == CateoryId
                           select pro;
            model.products = listJobs.Select(v => new ProductModel()
            {
                Title = CultureHelper.CurrentCulture == Lang.English ? v.Title : CultureHelper.CurrentCulture == Lang.French ? v.TitleFr : v.TitleNl, 
                Description = CultureHelper.CurrentCulture == Lang.English ? v.Description : CultureHelper.CurrentCulture == Lang.French ? v.DescriptionFr : v.DescriptionNl, 
                MainPhoto = v.MainImage
            }).ToList();
            var ListJobshtml = RenderPartialViewToString("_ProductitemAr", model);
            return Json(new
            {
                success = true,
                ListJobshtml = ListJobshtml
            });
        }
        public virtual string RenderPartialViewToString(string viewName, object model)
        {
            //Original source code: http://craftycodeblog.com/2010/05/15/asp-net-mvc-render-partial-view-to-string/
            if (string.IsNullOrEmpty(viewName))
                viewName = this.ControllerContext.RouteData.GetRequiredString("action");

            this.ViewData.Model = model;

            using (var sw = new StringWriter())
            {
                ViewEngineResult viewResult = System.Web.Mvc.ViewEngines.Engines.FindPartialView(this.ControllerContext, viewName);
                var viewContext = new ViewContext(this.ControllerContext, viewResult.View, this.ViewData, this.TempData, sw);
                viewResult.View.Render(viewContext, sw);

                return sw.GetStringBuilder().ToString();
            }
        }
        
    }
}