﻿using NahrCms.Web.Areas.admin.Controllers;
using NahrCms.Web.Areas.admin.DataModels.Models.Products;
using System.Collections.Generic;
using System.Linq;
using System.Web.Mvc;
using NahrCms.Web.Areas.admin.DataModels.Models.FrameWorkModels;
using NahrCms.DAL;

namespace NahrCms.Web.Areas.en.Controllers
{
    public class ProductController : BaseController
    {
      
        public ActionResult List(int? page, ProductModel model, string Category)
        {
            Setting obj = context.Settings.Where(x => x.Id == 1).FirstOrDefault();
            model.Header_Image = obj.Header_Photo;
            model.Footer_Image = obj.Product_Footer;
            model.ENCompanyName = obj.EnCompanyName;
            model.Photo = obj.Image;
            if (obj.MaterialMenu != null)
                model.MaterialsMenu = obj.MaterialMenu.Value;
            if (obj.EventMenu != null)
                model.EventsMenu = obj.EventMenu.Value;
            if (obj.ProjectMenu != null)
                model.ProjectMenu = obj.ProjectMenu.Value;
            if (obj.ProductMenu != null)
                model.ProductMenu = obj.ProductMenu.Value;
            if (obj.ShowRoomsMenu != null)
                model.ShowRoomsMenu = obj.ShowRoomsMenu.Value;
            if (obj.GalleryMenu != null)
                model.GalleryMenu = obj.GalleryMenu.Value;
            if (obj.NewsMenu != null)
                model.NewsMenu = obj.NewsMenu.Value;
            FilterModel(model);
            return View(model);
        }
        //public ActionResult HomePageSecondSection()
        //{
        //    ProductModel model = new ProductModel();
        //    model.ProductCategoryItems = context.ProjectCategories.Select(x => new ProductModel()
        //    {
        //        Id = x.Id,
        //        Title = x.Title,

        //    }).ToList();

        //    model.ProductItems = context.Products.Select(c => new ProductModel()
        //    {
        //        Id = c.Id,
        //        Title = c.Title,
        //        MainPhoto = c.MainImage,
        //        ProductCategoryId = c.CategoryId,

        //    }).Take(3).ToList();
        //    return PartialView("_HomePageSecondSection", model);
        //}
        public ActionResult HomePage()
        {
            ProductModel model = new ProductModel();
            model.ProductCategoryItems = context.ProjectCategories.Select(x => new ProductModel()
            {
                Id = x.Id,
                Title = x.Title,

            }).ToList();

            //model.ProductItems = context.Products.Select(c => new ProductModel()
            //{
            //    Id = c.Id,
            //    Title = c.Title,
            //    MainPhoto = c.MainImage,
            //    ProductCategoryId = c.CategoryId,

            //}).Take(9).ToList();
            return PartialView("_HomePage", model);
        }

        private void FilterModel(ProductModel model)
        {
            var langs = from c in context.ProductCategories.ToList()
                        select new BaseObject() { Id = c.Id, Category = c.Title };
            model.ProductCategoryList = new List<BaseObject>();
            model.ProductCategoryList.Add(new BaseObject() { Id = null, Category = "Select Category" });
            model.ProductCategoryList.AddRange(langs.ToList());
        }

        public ActionResult Details(string Title, ProductModel model)
        {
            var obj = context.Products.Where(x =>  x.Title.Replace(" ", "-") == Title).FirstOrDefault();

            Setting settingobj = context.Settings.Where(x => x.Id == 1).FirstOrDefault();
            model.Header_Image = settingobj.Header_Photo;
            model.Footer_Image = settingobj.Product_Footer;
            model.ENCompanyName = settingobj.EnCompanyName;
            model.Photo = settingobj.Image;
            if (settingobj.MaterialMenu != null)
                model.MaterialsMenu = settingobj.MaterialMenu.Value;
            if (settingobj.EventMenu != null)
                model.EventsMenu = settingobj.EventMenu.Value;
            if (settingobj.ProjectMenu != null)
                model.ProjectMenu = settingobj.ProjectMenu.Value;
            if (settingobj.ProductMenu != null)
                model.ProductMenu = settingobj.ProductMenu.Value;
            if (settingobj.ShowRoomsMenu != null)
                model.ShowRoomsMenu = settingobj.ShowRoomsMenu.Value;
            if (settingobj.GalleryMenu != null)
                model.GalleryMenu = settingobj.GalleryMenu.Value;
            if (settingobj.NewsMenu != null)
                model.NewsMenu = settingobj.NewsMenu.Value;
            model.Title = obj.Title;
            model.Description = obj.Description;
            model.MainPhoto = obj.MainImage;
            model.ProductCategory = obj.ProductCategory.Title;
            if (obj.PhotoGallery != null)
                model.PhotosUpload = obj.PhotoGallery.Split(',').ToList();

            return View(model);
        }
    }
}