﻿using NahrCms.DAL;
using NahrCms.Web.Areas.admin.Controllers;
using NahrCms.Web.Areas.admin.DataModels.Models.PhotoGallery;
using System.Linq;
using System.Web.Mvc;

namespace NahrCms.Web.Areas.en.Controllers
{
    public class PhotoGalleryController : BaseController
    {
        // GET: en/PhotoGallery
        public ActionResult Index()
        {
            return View();
        }

        public ActionResult Gallery()
        {
            PhotoGalleryModel model = new PhotoGalleryModel();
           
            model.PhotoGalleryItems = context.PhotoGalleries.Select(x => new PhotoGalleryModel()
            {
               Title=x.Title,
               Photo = x.Photo

            }).ToList();
            
            model.Items = context.PhotoGalleryItems.Where(x => x.PhotoGalleryId == model.Id).Select(x => new Item()
                {
                    Photo = x.Image,
                    Description = x.Description,
                    PhotoGalleryId = x.PhotoGalleryId.Value
                 
                }).ToList();
            Setting settingobj = context.Settings.Where(x => x.Id == 1).FirstOrDefault();
            model.Header_Image = settingobj.Header_Photo;
            model.Footer_Image = settingobj.Gallery_Footer;
            model.ENCompanyName = settingobj.EnCompanyName;
            model.Photo = settingobj.Image;
            if (settingobj.MaterialMenu != null)
                model.MaterialsMenu = settingobj.MaterialMenu.Value;
            if (settingobj.EventMenu != null)
                model.EventsMenu = settingobj.EventMenu.Value;
            if (settingobj.ProjectMenu != null)
                model.ProjectMenu = settingobj.ProjectMenu.Value;
            if (settingobj.ProductMenu != null)
                model.ProductMenu = settingobj.ProductMenu.Value;
            if (settingobj.ShowRoomsMenu != null)
                model.ShowRoomsMenu = settingobj.ShowRoomsMenu.Value;
            if (settingobj.GalleryMenu != null)
                model.GalleryMenu = settingobj.GalleryMenu.Value;
            if (settingobj.NewsMenu != null)
                model.NewsMenu = settingobj.NewsMenu.Value;
            return View(model);
        }
    }
}