﻿using NahrCms.Web.Areas.admin.Controllers;
using NahrCms.Web.Areas.admin.DataModels.Models.Content;
using System.Linq;
using System.Web.Mvc;
using NahrCms.Web.Areas.admin.DataModels.Models.PhotoGallery;
using NahrCms.DAL;

namespace NahrCms.Web.Areas.en.Controllers
{
    public class NewsController : BaseController
    {
        // GET: en/News
        public ActionResult Index()
        {
            return View();
        }
        //public ActionResult ContactUs()
        //{
        //    return View();
        //}
        public ActionResult HomePage()
        {
            NewsModel model = new NewsModel();
          
            model.NewsItems = context.News.Where(x => x.Featured == true).OrderByDescending(x => x.Date).Select(c => new NewsModel()
            {
                Id = c.Id,
                Description = c.Description,
                Title = c.Title,
                MainPhoto = c.Image,
                Date = c.Date
            }).Take(3).ToList();
            return PartialView("_HomePage", model);
        }

        public ActionResult List(NewsModel model)
        {
          
            model.NewsItems = context.News.OrderByDescending(x => x.Date).Select(c => new NewsModel()
            {
                Id = c.Id,
                Description = c.Description,
                Title = c.Title,
                MainPhoto = c.Image,
                Date = c.Date
            }).ToList();
            Setting settingobj = context.Settings.Where(x => x.Id == 1).FirstOrDefault();
            model.Header_Image = settingobj.Header_Photo;
            model.ENCompanyName = settingobj.EnCompanyName;
            model.Photo = settingobj.Image;
            if (settingobj.MaterialMenu != null)
                model.MaterialsMenu = settingobj.MaterialMenu.Value;
            if (settingobj.EventMenu != null)
                model.EventsMenu = settingobj.EventMenu.Value;
            if (settingobj.ProjectMenu != null)
                model.ProjectMenu = settingobj.ProjectMenu.Value;
            if (settingobj.ProductMenu != null)
                model.ProductMenu = settingobj.ProductMenu.Value;
            if (settingobj.ShowRoomsMenu != null)
                model.ShowRoomsMenu = settingobj.ShowRoomsMenu.Value;
            if (settingobj.GalleryMenu != null)
                model.GalleryMenu = settingobj.GalleryMenu.Value;
            if (settingobj.NewsMenu != null)
                model.NewsMenu = settingobj.NewsMenu.Value;
            return View(model);
        
        }

        public ActionResult Details(string Title, NewsModel model)
        {

            var obj = context.News.Where(x =>  x.Title.Replace(" ", "-") == Title).FirstOrDefault();
            Setting settingobj = context.Settings.Where(x => x.Id == 1).FirstOrDefault();
            model.Header_Image = settingobj.Header_Photo;
            model.ENCompanyName = settingobj.EnCompanyName;
            model.Photo = settingobj.Image;
            if (settingobj.MaterialMenu != null)
                model.MaterialsMenu = settingobj.MaterialMenu.Value;
            if (settingobj.EventMenu != null)
                model.EventsMenu = settingobj.EventMenu.Value;
            if (settingobj.ProjectMenu != null)
                model.ProjectMenu = settingobj.ProjectMenu.Value;
            if (settingobj.ProductMenu != null)
                model.ProductMenu = settingobj.ProductMenu.Value;
            if (settingobj.ShowRoomsMenu != null)
                model.ShowRoomsMenu = settingobj.ShowRoomsMenu.Value;
            if (settingobj.GalleryMenu != null)
                model.GalleryMenu = settingobj.GalleryMenu.Value;
            if (settingobj.NewsMenu != null)
                model.NewsMenu = settingobj.NewsMenu.Value;
            model.Title = obj.Title;
            model.Description = obj.Description;
            model.MainPhoto = obj.Image;
            model.Date = obj.Date;
            model.PhotoGalleryId = obj.PhotoGalleryId;
            model.Photos = context.PhotoGalleryItems.Where(x => x.PhotoGalleryId == model.PhotoGalleryId).Select(c => new Item()
            {
                Photo=c.Image,
                Description=c.Description
            }).ToList();
           
            return View(model);
        }
    }
}