﻿using NahrCms.DAL;
using NahrCms.Web.Areas.admin.Controllers;
using NahrCms.Web.Areas.admin.DataModels.Models.Materials;
using NahrCms.Web.Areas.admin.DataModels.Models.Products;
using System.Linq;
using System.Web.Mvc;

namespace NahrCms.Web.Areas.en.Controllers
{
    public class MaterialController : BaseController
    {
        // GET: en/Material
        public ActionResult Index()
        {
            MaterialModel model = new MaterialModel();
            Setting settingobj = context.Settings.Where(x => x.Id == 1).FirstOrDefault();
            model.ENCompanyName = settingobj.EnCompanyName;
            model.Photo = settingobj.Image;
            if (settingobj.MaterialMenu != null)
                model.MaterialsMenu = settingobj.MaterialMenu.Value;
            if (settingobj.EventMenu != null)
                model.EventsMenu = settingobj.EventMenu.Value;
            if (settingobj.ProjectMenu != null)
                model.ProjectMenu = settingobj.ProjectMenu.Value;
            if (settingobj.ProductMenu != null)
                model.ProductMenu = settingobj.ProductMenu.Value;
            if (settingobj.ShowRoomsMenu != null)
                model.ShowRoomsMenu = settingobj.ShowRoomsMenu.Value;
            if (settingobj.GalleryMenu != null)
                model.GalleryMenu = settingobj.GalleryMenu.Value;
            if (settingobj.NewsMenu != null)
                model.NewsMenu = settingobj.NewsMenu.Value;
            return View();
        }

        public ActionResult List(MaterialModel model)
        {
           
            model.MaterialsItems = context.Materials.Select(c => new MaterialModel()
            {
                Id = c.Id,
                Description = c.Description,
                Title = c.Title,
                MainPhoto = c.Image,
               
            }).ToList();
            Setting settingobj = context.Settings.Where(x => x.Id == 1).FirstOrDefault();
            model.Header_Image = settingobj.Header_Photo;
            model.Footer_Image = settingobj.Material_Footer;
            model.ENCompanyName = settingobj.EnCompanyName;
            model.Photo = settingobj.Image;
            return View(model);

        }

        public ActionResult Details(string Title, MaterialModel model)
        {

            var obj = context.Materials.Where(x => x.Title.Replace(" ", "-") == Title).FirstOrDefault();
            Setting settingobj = context.Settings.Where(x => x.Id == 1).FirstOrDefault();
            model.Header_Image = settingobj.Header_Photo;
            model.Footer_Image = settingobj.Material_Footer;
            model.ENCompanyName = settingobj.EnCompanyName;
            model.Photo = settingobj.Image;
            if (settingobj.MaterialMenu != null)
                model.MaterialsMenu = settingobj.MaterialMenu.Value;
            if (settingobj.EventMenu != null)
                model.EventsMenu = settingobj.EventMenu.Value;
            if (settingobj.ProjectMenu != null)
                model.ProjectMenu = settingobj.ProjectMenu.Value;
            if (settingobj.ProductMenu != null)
                model.ProductMenu = settingobj.ProductMenu.Value;
            if (settingobj.ShowRoomsMenu != null)
                model.ShowRoomsMenu = settingobj.ShowRoomsMenu.Value;
            if (settingobj.GalleryMenu != null)
                model.GalleryMenu = settingobj.GalleryMenu.Value;
            if (settingobj.NewsMenu != null)
                model.NewsMenu = settingobj.NewsMenu.Value;
            model.Title = obj.Title;
            model.Description = obj.Description;
            model.Type = obj.Type;
            model.Color = obj.Color;
            model.MainPhoto = obj.Image;
            model.ProductId = obj.ProductId;
            model.ProductItemList = context.Products.Where(x => x.Id == model.ProductId).Select(c => new ProductModel()
                {
                    Id = c.Id,
                    Title = c.Title
                }).ToList();
            if (obj.PhotoGallery != null)
                model.PhotosUpload = obj.PhotoGallery.Split(',').ToList();

            return View(model);
        }
    }
}