﻿using System.Linq;
using System.Web.Mvc;
using NahrCms.Web.Areas.admin.Controllers;
using NahrCms.Web.Areas.en.Models;
using System.Net.Mail;
using System.Text;
using System;
using NahrCms.DAL;
using NahrCms.Web.Areas.admin.DataModels.Models.Settings;
using NahrCms.Web.Areas.admin.DataModels.Models.Configuration;
using NahrCms.Web.Areas.admin.DataModels.Models.Products;
using NahrCms.Web.Helpers;
using NahrCms.Web.Models;
using System.Globalization;
using System.Threading;

namespace NahrCms.Web.Areas.en.Controllers
{
    public class HomeController : BaseController
    {
        public ActionResult ChangeCurrentCulture(int id)
        {
            CultureHelper.CurrentCulture = (Lang)id;
            Session["Culture"] = id;
            CultureInfo currentCulture = Thread.CurrentThread.CurrentCulture;
            // Redirect to the same page from where the request was made!   
            return Redirect(Request.UrlReferrer.ToString());
        }

        //public PartialViewResult _PopRegistrationar()
        //{
        //    ProductModel model = new ProductModel();
        //    model.productList.Add(new SelectListItem { Value = "تطبيق هذا المنتج", Text = "تطبيق هذا المنتج" });
        //    model.productList = context.Products.Select(v => new SelectListItem { Text = v.TitleAr, Value = v.TitleAr }).ToList();
        //    return PartialView(model);
        //}
        public PartialViewResult _PopRegistration()
        {
            ProductModel model = new ProductModel();
            model.productList.Add(new SelectListItem { Value = "Application of this product", Text = "Application of this product" });
            model.productList = context.Products.Select(v => new SelectListItem { Text = v.Title, Value = v.Title }).ToList();
            return PartialView(model);
        } 
        [HttpPost]
        public JsonResult sendToEmail(string CompanyName, string Adress, string countryen, string Telephone, string Website,
            string Companyactivity, string Personname, string Title, string Prointerested, string other,
            string Email, string Mobile)
        {
            Setting obj = context.Settings.Where(x => x.Id == 1).SingleOrDefault();
            try
            {
                System.Net.Mail.MailMessage msg = new System.Net.Mail.MailMessage();
                SmtpClient smtp = new SmtpClient("" + obj.SMTP + "");
                MailAddress from = new MailAddress(obj.Email);
                StringBuilder sb = new StringBuilder();
                msg.From = new MailAddress("info@BMS.com", CompanyName);// replace it with sender email address
                msg.To.Add(new MailAddress("info@BMS.com"));
                msg.Subject = "Registration";
                smtp.EnableSsl = true;
                smtp.UseDefaultCredentials = false;
                smtp.DeliveryMethod = SmtpDeliveryMethod.Network;
                smtp.Credentials = new System.Net.NetworkCredential(obj.Email, obj.Password);
                smtp.Port = 587;
                sb.Append("Company Name: " + CompanyName);
                sb.Append(Environment.NewLine);
                sb.Append("Adress: " + Adress);
                sb.Append(Environment.NewLine);
                sb.Append("Country: " + countryen);
                sb.Append(Environment.NewLine);
                sb.Append("Telephone: " + Telephone);
                sb.Append(Environment.NewLine);
                sb.Append("Email: " + Email);
                sb.Append(Environment.NewLine);
                sb.Append("Mobile: " + Mobile);
                sb.Append(Environment.NewLine);
                sb.Append("Website: " + Website);
                sb.Append(Environment.NewLine);
                sb.Append("Company activity: " + Companyactivity);
                sb.Append(Environment.NewLine);
                sb.Append("Title:" + Title);
                sb.Append(Environment.NewLine);
                sb.Append("Contact person name: " + Personname);
                if (Prointerested == "other")
                {
                    sb.Append(Environment.NewLine);
                    sb.Append("Product you are interested in: " + other);
                }
                else
                {
                    sb.Append(Environment.NewLine);
                    sb.Append("Product you are interested in: " + Prointerested);
                }
                msg.Body = sb.ToString();
                smtp.Send(msg);
                msg.Dispose();
                // TempData["alertMessage"] = "Thank You For Your Message";

                return Json(new { success = true, message = "" });
            }
            catch (Exception ex)
            {
                return Json(new { success = false, message = "" });
            }
            //return Json("Success");
        }
        public ActionResult Index()
        {
            ContactUsModel model = new ContactUsModel();
            Setting obj = context.Settings.Where(x => x.Id == 1).SingleOrDefault();
            model.facebookURL = obj.FaceBookURL;
            model.twitterURL = obj.TwitterURL;
            model.googleURL = obj.GoogleURL;
            model.address = obj.Address;
            model.contactMail = obj.Email;
            model.Photo = obj.Image;
            model.ENCompanyName = obj.EnCompanyName;
            if (obj.ShowAboutUs != null)
                 model.ShowAboutUs = obj.ShowAboutUs.Value;
             if (obj.ShowContactUs != null)
                    model.ShowContactus = obj.ShowContactUs.Value;
                if (obj.ShowEvents != null)
                    model.ShowEvents = obj.ShowEvents.Value;
                if (obj.ShowMission != null)
                    model.ShowMission = obj.ShowMission.Value;
                if (obj.ShowNews != null)
                    model.ShowNews = obj.ShowNews.Value;
                if (obj.ShowProduct != null)
                    model.ShowProducts = obj.ShowProduct.Value;
                if (obj.ShowProject != null)
                    model.ShowProjects = obj.ShowProject.Value;
                if (obj.ShowShowRooms != null)
                    model.ShowShowRooms = obj.ShowShowRooms.Value;
                if (obj.ShowSlider != null)
                    model.ShowSlider = obj.ShowSlider.Value;
                if (obj.MaterialMenu != null)
                    model.MaterialsMenu = obj.MaterialMenu.Value;
                if (obj.EventMenu != null)
                    model.EventsMenu = obj.EventMenu.Value;
                if (obj.ProjectMenu != null)
                    model.ProjectMenu = obj.ProjectMenu.Value;
                if (obj.ProductMenu != null)
                    model.ProductMenu = obj.ProductMenu.Value;
                if (obj.ShowRoomsMenu != null)
                    model.ShowRoomsMenu = obj.ShowRoomsMenu.Value;
                if (obj.GalleryMenu != null)
                    model.GalleryMenu = obj.GalleryMenu.Value;
                if (obj.NewsMenu != null)
                    model.NewsMenu = obj.NewsMenu.Value;

            var slider1 = context.Rotators.Where(x => x.Id == 4).FirstOrDefault();
            var slider2 = context.Rotators.Where(x => x.Id == 6).FirstOrDefault();
            var trading = context.News.Where(x => x.Id == 45).FirstOrDefault();
            model.title1 = CultureHelper.CurrentCulture == Lang.English ? slider1.Title : CultureHelper.CurrentCulture == Lang.French ? slider1.TitleFr : slider1.TitleNl;
            model.title2 = CultureHelper.CurrentCulture == Lang.English ? slider2.Title : CultureHelper.CurrentCulture == Lang.French ? slider2.TitleFr : slider2.TitleNl;
            model.title3 = CultureHelper.CurrentCulture == Lang.English ? trading.Title : CultureHelper.CurrentCulture == Lang.French ? trading.TitleFr : trading.TitleNl;
            
            model.desc1 = CultureHelper.CurrentCulture == Lang.English ? slider1.Description : CultureHelper.CurrentCulture == Lang.French ? slider1.DescriptionFr : slider1.DescriptionNl;
            model.desc2 = CultureHelper.CurrentCulture == Lang.English ? slider2.Description : CultureHelper.CurrentCulture == Lang.French ? slider2.DescriptionFr : slider2.DescriptionNl;
            model.desc3 = CultureHelper.CurrentCulture == Lang.English ? trading.Description : CultureHelper.CurrentCulture == Lang.French ? trading.DescriptionFr : trading.DescriptionNl;

            //var career1 = context.News.Where(s => s.Id == 24).FirstOrDefault();
            //var career2 = context.News.Where(s => s.Id == 27).FirstOrDefault();
            //var career3 = context.News.Where(s => s.Id == 31).FirstOrDefault();
            //var career4 = context.News.Where(s => s.Id == 36).FirstOrDefault();
            //model.title1 = career1.Title;
            //model.title2 = career2.Title;
            //model.title3 = career3.Title;
            //model.title4 = career4.Title;

            //model.desc1 = career1.Description;
            //model.desc2 = career2.Description;
            //model.desc3 = career3.Description;
            //model.desc4 = career4.Description;
            return View(model);
        }
        public ActionResult Success()
        {
            BaseModel model = new BaseModel();
            Setting seobj = context.Settings.Where(x => x.Id == 1).FirstOrDefault();
            model.ENCompanyName = seobj.EnCompanyName;
            return View(model);
        }

        public ActionResult Inner()
        {
            ContactUsModel model = new ContactUsModel();
            Setting obj = context.Settings.Where(x => x.Id == 1).SingleOrDefault();
            model.facebookURL = obj.FaceBookURL;
            model.twitterURL = obj.TwitterURL;
            model.googleURL = obj.GoogleURL;
            model.address = obj.Address;
            model.contactMail = obj.Email;
            model.Photo = obj.Image;
            if (obj.ShowAboutUs != null)
                model.ShowAboutUs = obj.ShowAboutUs.Value;
            if (obj.ShowContactUs != null)
                model.ShowContactus = obj.ShowContactUs.Value;
            if (obj.ShowEvents != null)
                model.ShowEvents = obj.ShowEvents.Value;
            if (obj.ShowMission != null)
                model.ShowMission = obj.ShowMission.Value;
            if (obj.ShowNews != null)
                model.ShowNews = obj.ShowNews.Value;
            if (obj.ShowProduct != null)
                model.ShowProducts = obj.ShowProduct.Value;
            if (obj.ShowProject != null)
                model.ShowProjects = obj.ShowProject.Value;
            if (obj.ShowShowRooms != null)
                model.ShowShowRooms = obj.ShowShowRooms.Value;
            if (obj.ShowSlider != null)
                model.ShowSlider = obj.ShowSlider.Value;
            if (obj.MaterialMenu != null)
                model.MaterialsMenu = obj.MaterialMenu.Value;
            if (obj.EventMenu != null)
                model.EventsMenu = obj.EventMenu.Value;
            if (obj.ProjectMenu != null)
                model.ProjectMenu = obj.ProjectMenu.Value;
            if (obj.ProductMenu != null)
                model.ProductMenu = obj.ProductMenu.Value;
            if (obj.ShowRoomsMenu != null)
                model.ShowRoomsMenu = obj.ShowRoomsMenu.Value;
            if (obj.GalleryMenu != null)
                model.GalleryMenu = obj.GalleryMenu.Value;
            if (obj.NewsMenu != null)
                model.NewsMenu = obj.NewsMenu.Value;
            return View(model);
        }
        public ActionResult MenuSections()
        {
            Setting obj = context.Settings.Where(x => x.Id == 1).SingleOrDefault();
            BaseModel model = new BaseModel();
            if (obj.MaterialMenu != null)
                model.MaterialsMenu = obj.MaterialMenu.Value;
            if (obj.EventMenu != null)
                model.EventsMenu = obj.EventMenu.Value;
            if (obj.ProjectMenu != null)
                model.ProjectMenu = obj.ProjectMenu.Value;
            if (obj.ProductMenu != null)
                model.ProductMenu = obj.ProductMenu.Value;
            if (obj.ShowRoomsMenu != null)
                model.ShowRoomsMenu = obj.ShowRoomsMenu.Value;
            if (obj.GalleryMenu != null)
                model.GalleryMenu = obj.GalleryMenu.Value;
            if (obj.NewsMenu!= null)
                model.NewsMenu = obj.NewsMenu.Value;
            model.Photo = obj.Image;
            return View(model);
        }


        [ChildActionOnly]
        public ActionResult Menu()
        {
            var model = context.Pages.Where(p => p.Deleted == false && p.OnMenu == true).OrderBy(x => x.Order)
                .Select(x => new MenuModel()
                {
                    Id = x.Id,
                    Title = x.Title,
                    ParentId = x.ParentId,
                    Pages = x.Page1
                })
                .ToList();
            return PartialView("Menu", model);
        }

        public ActionResult Content(string Title)
        {
            var content = context.Pages.Where(p => "-"+p.Title.Replace(" ","-") == Title).Select(c => new MenuModel()
            {
                Id = c.Id,
                Title = c.Title,
                Content = c.Content,
                SeoTitle=c.Title.Replace(" ","-")
            }).FirstOrDefault();
            Setting settingobj = context.Settings.Where(x => x.Id == 1).FirstOrDefault();
            content.Header_Image = settingobj.Header_Photo;
            content.ENCompanyName = settingobj.EnCompanyName;
            content.Photo = settingobj.Image;
            if (settingobj.MaterialMenu != null)
                content.MaterialsMenu = settingobj.MaterialMenu.Value;
            if (settingobj.EventMenu != null)
                content.EventsMenu = settingobj.EventMenu.Value;
            if (settingobj.ProjectMenu != null)
                content.ProjectMenu = settingobj.ProjectMenu.Value;
            if (settingobj.ProductMenu != null)
                content.ProductMenu = settingobj.ProductMenu.Value;
            if (settingobj.ShowRoomsMenu != null)
                content.ShowRoomsMenu = settingobj.ShowRoomsMenu.Value;
            if (settingobj.GalleryMenu != null)
                content.GalleryMenu = settingobj.GalleryMenu.Value;
            if (settingobj.NewsMenu != null)
                content.NewsMenu = settingobj.NewsMenu.Value;
            return View(content);
        }

        [HttpPost]
        public ActionResult SendMail(ContactUsModel model)
        {
            Setting obj = context.Settings.Where(x => x.Id == 1).SingleOrDefault();

            if (ModelState.IsValid)
            {
                try
                {
                    System.Net.Mail.MailMessage msg = new System.Net.Mail.MailMessage();
                    SmtpClient smtp = new SmtpClient("" + obj.SMTP + "");
                    MailAddress from = new MailAddress(model.email.ToString());
                    StringBuilder sb = new StringBuilder();
                    msg.From = new MailAddress(model.email.ToString());// replace it with sender email address
                    msg.To.Add("" + obj.Email + "");
                    msg.Subject = "Contact Us";
                    smtp.EnableSsl = true;
                    smtp.UseDefaultCredentials = true;
                    smtp.Credentials = new System.Net.NetworkCredential("" + obj.Email + "", obj.Password);
                    smtp.Port = 587;
                    sb.Append("First name: " + model.name);
                    sb.Append(Environment.NewLine);
                    sb.Append("Email: " + model.email);
                    sb.Append(Environment.NewLine);
                    sb.Append("Phone " + model.Phone);
                    sb.Append(Environment.NewLine);
                    sb.Append("Message: " + model.Message);
                    msg.Body = sb.ToString();
                    smtp.Send(msg);
                    msg.Dispose();
                    TempData["alertMessage"] = "Thank You For Your Message";
                    


                    return RedirectToAction("Success", "Home");
                }
                catch (Exception)
                {
                    return View("Error");
                }

            }
            TempData["alertMessage"] = "Please Enter All Required Data";
            return View("Error");
        }
    }
}