﻿using NahrCms.Web.Areas.admin.Controllers;
using NahrCms.Web.Areas.admin.DataModels.Models.Content;
using NahrCms.Web.Areas.admin.DataModels.Models.FrameWorkModels;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web.Mvc;
using PagedList;
using NahrCms.Web.Areas.admin.DataModels.Models.PhotoGallery;
using NahrCms.DAL;


namespace NahrCms.Web.Areas.en.Controllers
{
    public class EventController : BaseController
    {
        // GET: en/Event
        public ActionResult Index(EventModel model)
        {
            Setting seobj = context.Settings.Where(x => x.Id == 1).FirstOrDefault();
            model.ENCompanyName = seobj.EnCompanyName;
            FilterModel(model);
            return View(model);
        }

        public ActionResult List(int? page, EventModel model, string Category , string dateFrom , string dateTo)
        {
          
            var list = context.Events.OrderBy(x => x.Id);
            Setting settingobj = context.Settings.Where(x => x.Id == 1).FirstOrDefault();
            model.Header_Image = settingobj.Header_Photo;
            model.Footer_Image = settingobj.Event_Footer;
            model.ENCompanyName = settingobj.EnCompanyName;
            model.Photo = settingobj.Image;
            if (settingobj.MaterialMenu != null)
                model.MaterialsMenu = settingobj.MaterialMenu.Value;
            if (settingobj.EventMenu != null)
                model.EventsMenu = settingobj.EventMenu.Value;
            if (settingobj.ProjectMenu != null)
                model.ProjectMenu = settingobj.ProjectMenu.Value;
            if (settingobj.ProductMenu != null)
                model.ProductMenu = settingobj.ProductMenu.Value;
            if (settingobj.ShowRoomsMenu != null)
                model.ShowRoomsMenu = settingobj.ShowRoomsMenu.Value;
            if (settingobj.GalleryMenu != null)
                model.GalleryMenu = settingobj.GalleryMenu.Value;
            if (settingobj.NewsMenu != null)
                model.NewsMenu = settingobj.NewsMenu.Value;
            int itemsPerPage = 30;
            int pageNumber = page ?? 1;
            model.ListEvents = list.ToPagedList(pageNumber, itemsPerPage);
            FilterModel(model);
            model.EventCategoryItems = context.EventCategories.Select(x => new EventModel()
            {
                Id = x.Id,
                Title = x.Title
            }

                ).ToList();

            if (Category == "All")
            {
                model.EventItems = context.Events.OrderByDescending(x => x.Id).Select(c => new EventModel()
                {
                    Id = c.Id,
                    Title = c.Title,
                    MainPhoto = c.Image,
                    Description = c.Description
                }).ToList();
                return PartialView("_List", model);
            }

            if (Category != null)
            {
                model.EventItems = context.Events.Where(x => x.EventCategory.Title == Category).OrderByDescending(x => x.Id).Select(c => new EventModel()
                {
                    Id = c.Id,
                    Title = c.Title,
                    MainPhoto = c.Image,
                    Description = c.Description
                }).ToList();
                return PartialView("_List", model);
            }



            if (dateTo != null && dateFrom != null)
            {
                model.EventItems = context.Events.AsEnumerable().
                    Where(x => x.Date.Value.Month >= Convert.ToInt32(dateFrom) &&
                    x.Date.Value.Month <= Convert.ToInt32(dateTo)).OrderByDescending(x => x.Id).Select(c => new EventModel()
                {
                    Id = c.Id,
                    Title = c.Title,
                    MainPhoto = c.Image,
                    Description = c.Description
                }).ToList();
                return PartialView("_List", model);
            }
            model.EventItems = context.Events.OrderByDescending(x => x.Id).Select(c => new EventModel()
            {
                Id = c.Id,
                Title = c.Title,
                MainPhoto = c.Image,
                Description = c.Description
            }).ToList();
            return View(model);
        }
        private void FilterModel(EventModel model)
        {
            var list = new SelectList(new[] 
              {
                   new { ID = "1", Name = "January" },
                   new { ID = "2", Name = "February" },
                   new { ID = "3", Name = "March" },
                   new { ID = "4", Name = "April" },
                   new { ID = "5", Name = "May" },
                   new { ID = "6", Name = "June" },
                    new { ID = "7", Name = "July" },
                     new { ID = "8", Name = "August" },
                      new { ID = "9", Name = "September" },
                     new { ID = "10", Name = "October" },
                      new { ID = "11", Name = "November" },
                       new { ID = "12", Name = "December" },
                     
              }, "ID", "Name", 1);

            ViewData["list"] = list;
           // ViewData["list1"] = list;
            model.DateListFrom = list.ToString();
            model.DateListTo = list.ToString();


            var langs = from c in context.EventCategories.ToList()
                        select new BaseObject() { Id = c.Id, Category = c.Title };
            var date = from c in context.Events.ToList()
                       select new BaseObject() { Id = c.Id, Date = c.Date.Value };

            model.EventCategoryList = new List<BaseObject>();
           

            model.EventCategoryList.Add(new BaseObject() { Id = null, Category = "All" });
           
            model.EventCategoryList.AddRange(langs.ToList());
            
        }

        public ActionResult Details(string Title, EventModel model)
        {

            var obj = context.Events.Where(x =>  x.Title.Replace(" ", "-") == Title).FirstOrDefault();
            Setting settingobj = context.Settings.Where(x => x.Id == 1).FirstOrDefault();
            model.Header_Image = settingobj.Header_Photo;
            model.Footer_Image = settingobj.Event_Footer;
            model.Photo = settingobj.Image;
            model.ENCompanyName = settingobj.EnCompanyName;
            if (settingobj.MaterialMenu != null)
                model.MaterialsMenu = settingobj.MaterialMenu.Value;
            if (settingobj.EventMenu != null)
                model.EventsMenu = settingobj.EventMenu.Value;
            if (settingobj.ProjectMenu != null)
                model.ProjectMenu = settingobj.ProjectMenu.Value;
            if (settingobj.ProductMenu != null)
                model.ProductMenu = settingobj.ProductMenu.Value;
            if (settingobj.ShowRoomsMenu != null)
                model.ShowRoomsMenu = settingobj.ShowRoomsMenu.Value;
            if (settingobj.GalleryMenu != null)
                model.GalleryMenu = settingobj.GalleryMenu.Value;
            if (settingobj.NewsMenu != null)
                model.NewsMenu = settingobj.NewsMenu.Value;
            model.Title = obj.Title;
            model.Description = obj.Description;
            model.MainPhoto = obj.Image;
            model.Date = obj.Date.Value;
            model.PhotoGalleryId = obj.PhotoGalleryId;
            model.Photos = context.PhotoGalleryItems.Where(x => x.PhotoGalleryId == model.PhotoGalleryId).Select(c => new Item()
            {
                Photo = c.Image,
                Description = c.Description
            }).ToList();

            return View(model);
        }
    }
}