﻿using System.Web.Mvc;
using System.Web.Optimization;

namespace NahrCms.Web.Areas.en
{
    public class enAreaRegistration : AreaRegistration
    {
        public override string AreaName => "en";

        public override void RegisterArea(AreaRegistrationContext context)
        {
            context.MapRoute(
                "EN_default",
                "{controller}/{action}/{id}",
                new { action = "Index", id = UrlParameter.Optional },
                new { controller = "Home" },
                namespaces: new[] { "NahrCms.Web.Areas.en.Controllers" }
            );

            context.MapRoute(
                "ShowRoomList",
               "showroom/index",
                new { controller = "ShowRoom", action = "Index" },
               new[] { "NahrCms.Web.Areas.en.Controllers" }
           );

            ScriptBundle jsArea = new ScriptBundle("~/bundles/libs.js");
            jsArea
                .IncludeDirectory("~/Content/front", "*.js", true);
            //.IncludeDirectory("~/Areas/clinics/Scripts", "*.js", true);

            StyleBundle styleArea = new StyleBundle("~/bundles/libs.css");
            styleArea
                .IncludeDirectory("~/Content/front", "*.css", true);
            //.IncludeDirectory("~/Areas/clinics/Scripts", "*.js", true);


            BundleTable.Bundles.Add(jsArea);
            BundleTable.Bundles.Add(styleArea);

            context.MapRoute(
               "PartialProductEN",
               "product",
                new { controller = "Product", action = "List" }
           );

            context.MapRoute(
           name: "ViewProductEN",
           url: "product/{Title}",
           defaults: new { controller = "Product", action = "Details"}
           );

            context.MapRoute(
               "PartialProjectEN",
               "project",
                new { controller = "Project", action = "List" }
           );

            context.MapRoute(
           name: "ViewProjectEN",
           url: "project/{Title}",
           defaults: new { controller = "Project", action = "Details" }
           );

             context.MapRoute(
               "PartialPagesEN",
               "project",
                new { controller = "Home", action = "Content" }
           );

            context.MapRoute(
           name: "ViewPagesEN",
           url: "page/{Title}",
           defaults: new { controller = "Home", action = "Content" }
           );

           context.MapRoute(
              "PartialEventEN",
              "event",
               new { controller = "Event", action = "List" }
          );
       

            context.MapRoute(
           name: "ViewEventEN",
           url: "event/{Title}",
           defaults: new { controller = "Event", action = "Details"}
      
           );

            context.MapRoute(
              "PartialMaterialEN",
              "material",
               new { controller = "Material", action = "List" }
          );

            context.MapRoute(
                name: "ViewMaterialEN",
                url: "material/{Title}",
                defaults :new { controller = "Material", action = "Details" }
           );

            context.MapRoute(
               "PartialNewsEN",
               "news",
                new { controller = "News", action = "List" }
           );

            context.MapRoute(
           name: "ViewNewsEN",
           url: "news/{Title}",
           defaults: new { controller = "News", action = "Details" }
           
           );
        }


    }
}