﻿using System.Web.Mvc;

namespace NahrCms.Web.Areas.en.AreaConfig
{
    internal static class RouteConfig
    {
        internal static void RegisterRoutes(AreaRegistrationContext context)
        {
            context.MapRoute(
                "EN_default",
                "en/{controller}/{action}/{id}",
                new { action = "Index", id = UrlParameter.Optional },
                new { controller = "Home" },
                namespaces: new[] { "NahrCms.Web.Areas.en.Controllers" }
            );

            context.MapRoute(
                "ShowRoomList",
               "en/showroom/index",
                new { controller = "ShowRoom", action = "Index" },
               new[] { "NahrCms.Web.Areas.en.Controllers" }
           );
            context.MapRoute(
               "PartialProductEN",
               "en/Product",
                new { controller = "Product", action = "List" }
           );

            context.MapRoute(
           name: "ViewProductEN",
           url: "en/Product/Details/{Id}/{Title}",
           defaults: new { controller = "Product", action = "Details" }
           );

            context.MapRoute(
               "PartialProjectEN",
               "en/Project",
                new { controller = "Project", action = "List" }
           );

            context.MapRoute(
           name: "ViewProjectEN",
           url: "en/Project/Details/{Id}/{Title}",
           defaults: new { controller = "Project", action = "Details" }
           );

            context.MapRoute(
              "PartialEventEN",
              "en/Event",
               new { controller = "Event", action = "Index" }
          );

            context.MapRoute(
          name: "ViewEventEN",
          url: "en/Event/Details/{Id}/{Title}",
          defaults: new { controller = "Event", action = "Details" }
          );

            context.MapRoute(
              "PartialMaterialEN",
              "en/Material",
               new { controller = "Material", action = "List" }
          );

            context.MapRoute(
           name: "ViewMaterialEN",
           url: "en/Material/Details/{Id}/{Title}",
           defaults: new { controller = "Material", action = "Details" }
           );

            context.MapRoute(
               "PartialNewsEN",
               "en/News",
                new { controller = "News", action = "Index" }
           );

            context.MapRoute(
           name: "ViewNewsEN",
           url: "en/News/Details/{Id}/{Title}",
           defaults: new { controller = "News", action = "Details" }
           );
        }
    }
}
