﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web.Http;
using NahrCms.DAL;
using NahrCms.Web.Areas.admin.DataModels.Models.Configuration;

namespace NahrCms.Web.Areas.en.Controllers
{
    [RoutePrefix("en/api/welcome")]
    public class ApiWelcomeController : ApiController
    {
        protected NahrCmsAppEntities context = new NahrCmsAppEntities();

        [HttpGet]
        [Route("{date}/getwelcome")]
        public WelcomeModel Get(string date = "")
        {
            if (date == "web")
            {
                WelcomeModel model = new WelcomeModel();
                Welcome obj = context.Welcomes.Where(x => x.Id == 1).FirstOrDefault();
                model.Title = obj.Title;
                model.Id = obj.Id;
                model.Content = obj.Content;
                return model;
            }
            else
            {
                if (date != "first")
                {

                    DateTime enteredDate = DateTime.Parse(date, null, System.Globalization.DateTimeStyles.RoundtripKind);
                    WelcomeModel model = new WelcomeModel();
                    List<Welcome> obj = context.Welcomes
                        .Where(x => x.Id == 1)
                        .Where(x => x.UpdatedDate > enteredDate).ToList();
                    if (obj.Count() != 0)
                    {
                        var welcome = obj.FirstOrDefault();
                        model.Title = welcome.Title;
                        model.Id = welcome.Id;
                        model.Content = welcome.Content;
                        model.UpdatedDate = welcome.UpdatedDate;
                    }
                    else
                    {

                    }
                    return model;
                }
                else
                {
                    WelcomeModel model = new WelcomeModel();
                    Welcome obj = context.Welcomes
                        .Where(x => x.Id == 1).FirstOrDefault();
                    model.Title = obj.Title;
                    model.Id = obj.Id;
                    model.Content = obj.Content;
                    model.UpdatedDate = obj.UpdatedDate;
                    return model;
                }
            }
        }

        public class TestModel
        {
            public int Id { get; set; }
            public string Title { get; set; }
            public DateTime? CreatedDate { get; set; }
            public DateTime? UpdatedDate { get; set; }
        }
    }
}
