﻿
using NahrCms.DAL;
using NahrCms.Web.Areas.en.Models;
using System;
using System.Collections.Generic;
using System.Web.Http;
using System.Web.Http.Cors;
using System.Linq;
using NahrCms.Web.Areas.admin.DataModels.Models.Settings;
using NahrCms.Web.Areas.admin.DataModels.Models.Configuration;

namespace NahrCms.Web.Areas.en.Api
{
    [RoutePrefix("en/api/setting")]
    //[EnableCors(origins: "*", headers: "*", methods: "*")]
    public class ApiSettingController : ApiController
    {
        protected NahrCmsAppEntities context = new NahrCmsAppEntities();

        [HttpGet]
        [Route("{date}/getworkingdays")]
        public IEnumerable<WorkingDaysModel> GetWorkingDays(string date = "")
        {
            if (date != "first")
            {
                DateTime enteredDate = DateTime.Parse(date, null, System.Globalization.DateTimeStyles.RoundtripKind);
                var data = context.DaySettings
                    .Where(x => x.UpdatedDate > enteredDate).Select(p => new WorkingDaysModel()
                    {
                        Id = p.Id,
                        DayName = p.DayName,
                        CloseAt = p.CloseAt,
                        OpenAt = p.OpenAt,
                        UpdatedDate = p.UpdatedDate.Value,
                        working = p.working
                    }).ToList();
                return data;
            }
            else
            {
                var data = context.DaySettings.Select(p => new WorkingDaysModel()
                {
                    Id = p.Id,
                    DayName = p.DayName,
                    CloseAt = p.CloseAt,
                    OpenAt = p.OpenAt,
                    UpdatedDate = p.UpdatedDate.Value,
                    working = p.working
                }).ToList();
                return data;
            }

        }

        [HttpGet]
        [Route("{date}/getsettings")]
        public IEnumerable<SettingModel> GetSettings(string date = "")
        {
            if (date != "first")
            {
                DateTime enteredDate = DateTime.Parse(date, null, System.Globalization.DateTimeStyles.RoundtripKind);
                var data = context.Settings
                    .Where(x => x.UpdatedDate > enteredDate).Select(p => new SettingModel()
                    {
                        id = p.Id,
                        headerImage = p.Header_Photo,
                        Photo = p.Image,
                        FacebookURL = p.FaceBookURL,
                        TwitterURL = p.TwitterURL,
                        GoogleURL = p.GoogleURL,
                        Address = p.Address,
                        ENCompanyName = p.EnCompanyName,
                        CompanyPhone = p.CompanyPhone.ToString(),
                        Latitude = p.Latitude,
                        Longitude = p.Longitude,
                        UpdatedDate = p.UpdatedDate,
                        email=p.Email
                    }).ToList();
                return data;
            }
            else
            {
                var data = context.Settings.Select(p => new SettingModel()
                {
                    headerImage = p.Header_Photo,
                    Photo = p.Image,
                    FacebookURL = p.FaceBookURL,
                    TwitterURL = p.TwitterURL,
                    GoogleURL = p.GoogleURL,
                    Address = p.Address,
                    ENCompanyName = p.EnCompanyName,
                    CompanyPhone = p.CompanyPhone.ToString(),
                    Latitude = p.Latitude,
                    Longitude = p.Longitude,
                    UpdatedDate = p.UpdatedDate,
                    email = p.Email
                }).ToList();
                return data;
            }
        }

        [HttpGet]
        [Route("{date}/getslider")]
        public IEnumerable<SliderModel> GetSlider(string date = "")
        {
            if (date != "first")
            {
                DateTime enteredDate = DateTime.Parse(date, null, System.Globalization.DateTimeStyles.RoundtripKind);
                
                var data = context
                    .Rotators.Where(x => x.UpdatedDate > enteredDate)
                    .Select(p => new SliderModel()
                {
                    Id = p.Id,
                    Image = p.Photo,
                    Title = p.Title,
                    Description = p.Description,
                    UpdatedDate = p.UpdatedDate
                }).ToList();
                return data;
            }
            else
            {
                var data = context.Rotators.Select(p => new SliderModel()
                {
                    Id = p.Id,
                    Image = p.Photo,
                    Title = p.Title,
                    Description = p.Description,
                    UpdatedDate = p.UpdatedDate
                }).ToList();
                return data;
            }
        }
    }
}