﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web.Http;
using NahrCms.DAL;
using NahrCms.Web.Areas.admin.DataModels.Models.Projects;
namespace NahrCms.Web.Areas.en.Api
{
    [RoutePrefix("en/api/project")]
    public class ApiProjectController : ApiController
    {
        protected NahrCmsAppEntities context = new NahrCmsAppEntities();
        const int recordsPerPage = 10;

        [Route("{id}/projectdetail")]
        public ProjectModel GetContent(int id)
        {
            var model = context.Projects.Where(p => p.Id == id)
                .Select(x => new ProjectModel()
                {
                    Id = x.Id,
                    Title = x.Title,
                    MainPhoto = x.MainImage,
                    Description = x.Description,
                    SeoTitle= x.Title.Replace(" ","-")
                }).FirstOrDefault();
            return model;
        }

        [Route("{date}/getall")]
        [HttpGet]
        public IEnumerable<ProjectModel> GetProjects(int id=0, int? categoryId=0, string date="")
        {
            //if (String.IsNullOrEmpty(date))
            if (date == "web")
            {
                var skipRecords = id * recordsPerPage;

                var query = context.Projects.OrderBy(x => x.Id)
                   .Where(p => (!categoryId.HasValue || p.ProjectCategory.Id == categoryId))
                   .Select(p => new ProjectModel()
                   {
                       Id = p.Id,
                       Title = p.Title,
                       ShortDescription = p.ShortDescription,
                       MainPhoto = p.MainImage,
                       SeoTitle = p.Title.Replace(" ", "-")
                   }).Skip(skipRecords).Take(recordsPerPage);
                return query;
            }
            else
            {
                //DateTime? d = new DateTime();

                if (date != "first")
                {
                    //DateTime enteredDate = DateTime.Parse(date);
                    DateTime enteredDate = DateTime.Parse(date, null, System.Globalization.DateTimeStyles.RoundtripKind);
                    var data = context.Projects
                        .Where(x => x.UpdatedDate > enteredDate).Select(p => new ProjectModel()
                        {
                            Id = p.Id,
                            Title = p.Title,
                            ShortDescription = p.ShortDescription,
                            TitleAr = p.TitleAr,
                            Description = p.Description,
                            MainPhoto = p.MainImage,
                            ProjectCategoryId = p.CategoryId.Value,
                            UpdatedDate = p.UpdatedDate.Value,
                            SeoTitle = p.Title.Replace(" ", "-")

                        }).ToList();
                    return data;
                }
                else
                {
                    var data = context.Projects.Select(p => new ProjectModel()
                    {
                        Id = p.Id,
                        Title = p.Title,
                        ShortDescription = p.ShortDescription,
                        TitleAr = p.TitleAr,
                        Description = p.Description,
                        MainPhoto = p.MainImage,
                        ProjectCategoryId = p.CategoryId.Value,
                        UpdatedDate = p.UpdatedDate.Value,
                        SeoTitle = p.Title.Replace(" ", "-")

                    }).ToList();
                    return data;
                }
            }
        }

        [Route("{date}/syncprojects")]
        [HttpGet]
        public List<ProjectModel> SyncProjects(string date)
        {
            if (!String.IsNullOrEmpty(date) && date != "first")
            {
                //DateTime enteredDate = DateTime.Parse(date);
                DateTime enteredDate = DateTime.Parse(date, null, System.Globalization.DateTimeStyles.RoundtripKind);
                var data = context.Projects
                    .Where(x => x.UpdatedDate > enteredDate).Select(p => new ProjectModel()
                    {
                        Id = p.Id,
                        Title = p.Title,
                        ShortDescription = p.ShortDescription,
                        TitleAr = p.TitleAr,
                        Description = p.Description,
                        MainPhoto = p.MainImage,
                        ProjectCategoryId = p.CategoryId.Value,
                        UpdatedDate = p.UpdatedDate.Value
                    }).ToList();
                return data;
            }
            else
            {
                var data = context.Projects.Select(p => new ProjectModel()
                {
                    Id = p.Id,
                    Title = p.Title,
                    ShortDescription = p.ShortDescription,
                    TitleAr = p.TitleAr,
                    Description = p.Description,
                    MainPhoto = p.MainImage,
                    ProjectCategoryId = p.CategoryId.Value,
                    UpdatedDate = p.UpdatedDate.Value
                }).ToList();
                return data;
            }

        }
    }
}
