﻿using System;
using NahrCms.DAL;
using NahrCms.Web.Areas.admin.DataModels.Models.Products;
using System.Collections.Generic;
using System.Web.Http;
using System.Linq;
using NahrCms.Web.Helpers;
using NahrCms.Web.Models;

namespace NahrCms.Web.Areas.en.Api
{
    [RoutePrefix("en/api/product")]
    public class ApiProductController : ApiController
    {
        protected NahrCmsAppEntities context = new NahrCmsAppEntities();
        const int recordsPerPage = 10;

        [Route("{date}/getall")]
        [HttpGet]
        public IEnumerable<ProductModel> GetProducts(int id = 0, int? categoryId = 0, string date = "")
        {
            if (date == "web")
            {
                var skipRecords = id * recordsPerPage;

                var query = context.Products.OrderBy(x => x.Id)
                    .Where(p => (!categoryId.HasValue || p.CategoryId == categoryId))
                    .Select(p => new ProductModel()
                    {
                        Id = p.Id,
                        Title = p.Title,
                        ShortDescription = p.ShortDescription,
                        MainPhoto = p.MainImage,
                        SeoTitle = p.Title.Replace(" ", "-")
                    }).Skip(skipRecords).Take(recordsPerPage);

                return query;
            }
            else
            {
                if (date != "first")
                {
                    //DateTime enteredDate = DateTime.Parse(date);
                    DateTime enteredDate = DateTime.Parse(date, null, System.Globalization.DateTimeStyles.RoundtripKind);
                    var data = context.Products
                        .Where(x => x.UpdatedDate > enteredDate).Select(p => new ProductModel()
                        {
                            Id = p.Id,
                            Title = p.Title,
                            ShortDescription = p.ShortDescription,
                           // TitleAr = p.TitleAr,
                            Description = p.Description,
                            MainPhoto = p.MainImage,
                            ProductCategoryId = p.CategoryId.Value,
                            UpdatedDate = p.UpdatedDate.Value,
                            SeoTitle = p.Title.Replace(" ", "-")
                        }).ToList();
                    return data;
                }
                else
                {
                    var data = context.Products.Select(p => new ProductModel()
                    {
                        Id = p.Id,
                        Title = CultureHelper.CurrentCulture == Lang.English ? p.Title : CultureHelper.CurrentCulture == Lang.French ? p.TitleFr : p.TitleNl,
                        ShortDescription = CultureHelper.CurrentCulture == Lang.English ? p.ShortDescription : CultureHelper.CurrentCulture == Lang.French ? p.ShortDescriptionFr : p.ShortDescriptionNl,
                        Description = CultureHelper.CurrentCulture == Lang.English ? p.Description : CultureHelper.CurrentCulture == Lang.French ? p.DescriptionFr : p.DescriptionNl,
                        MainPhoto = p.MainImage,
                        ProductCategoryId = p.CategoryId.Value,
                        UpdatedDate = p.UpdatedDate.Value,
                        SeoTitle = CultureHelper.CurrentCulture == Lang.English ? p.Title.Replace(" ", "-") : CultureHelper.CurrentCulture == Lang.French ? p.TitleFr.Replace(" ", "-") : p.TitleNl.Replace(" ", "-")
                    }).ToList();
                    return data;
                }
            }
        }

        [Route("{id}/productdetail")]
        public ProductModel GetDetails(int id)
        {
            var model = context.Products.Where(p => p.Id == id)
                .Select(x => new ProductModel()
                {
                    Id = x.Id,
                    Title = x.Title,
                    MainPhoto = x.MainImage,
                    Description = x.Description,
                    SeoTitle = x.Title.Replace(" ", "-")
                }).FirstOrDefault();
            return model;
        }

        [Route("{date}/syncproducts")]
        [HttpGet]
        public List<ProductModel> SyncProducts(string date)
        {
            if (!String.IsNullOrEmpty(date) && date != "first")
            {
                //DateTime enteredDate = DateTime.Parse(date);
                DateTime enteredDate = DateTime.Parse(date, null, System.Globalization.DateTimeStyles.RoundtripKind);
                var data = context.Products
                    .Where(x => x.UpdatedDate > enteredDate).Select(p => new ProductModel()
                    {
                        Id = p.Id,
                        Title = p.Title,
                        ShortDescription = p.ShortDescription, 
                        Description = p.Description,
                        MainPhoto = p.MainImage,
                        ProductCategoryId = p.CategoryId.Value,
                        UpdatedDate = p.UpdatedDate.Value,
                        SeoTitle = p.Title.Replace(" ", "-")
                    }).ToList();
                return data;
            }
            else
            {
                var data = context.Products.Select(p => new ProductModel()
                {
                    Id = p.Id,
                    Title = p.Title,
                    ShortDescription = p.ShortDescription, 
                    Description = p.Description,
                    MainPhoto = p.MainImage,
                    ProductCategoryId = p.CategoryId.Value,
                    UpdatedDate = p.UpdatedDate.Value,
                    SeoTitle = p.Title.Replace(" ", "-")
                }).ToList();
                return data;
            }

        }
    }
}
