﻿using NahrCms.DAL;
using NahrCms.Web.Areas.admin.DataModels.Models.Content;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web.Http;

namespace NahrCms.Web.Areas.en.Api
{
    [RoutePrefix("en/api/news")]
    public class ApiNewsController : ApiController
    {
        protected NahrCmsAppEntities context = new NahrCmsAppEntities();
        const int recordsPerPage = 10;

        [Route("{date}/getall")]
        [HttpGet]
        public IEnumerable<NewsModel> GetNews(int id = 0, string date = "")
        {
            if (date == "web")
            {
                var skipRecords = id * recordsPerPage;

                var query = context.News.OrderByDescending(x => x.Date)
                   .Select(p => new NewsModel()
                   {
                       Id = p.Id,
                       Title = p.Title,
                       Description = p.Description,
                       MainPhoto = p.Image,
                       Date = p.Date,
                       SeoTitle = p.Title.Replace(" ", "-")
                   }).Skip(skipRecords).Take(recordsPerPage);
                return query;
            }
            else
            {
                if (date != "first")
                {
                    DateTime enteredDate = DateTime.Parse(date, null, System.Globalization.DateTimeStyles.RoundtripKind);
                    var data = context.News
                        .Where(x => x.UpdatedDate > enteredDate).Select(p => new NewsModel()
                        {
                            Id = p.Id,
                            Title = p.Title,
                            Description = p.Description,
                            MainPhoto = p.Image,
                            Date = p.Date,
                            UpdatedDate = p.UpdatedDate.Value,
                            SeoTitle = p.Title.Replace(" ", "-")
                        }).ToList();
                    return data;
                }
                else
                {
                    var data = context.News.Select(p => new NewsModel()
                    {
                        Id = p.Id,
                        Title = p.Title,
                        Description = p.Description,
                        MainPhoto = p.Image,
                        Date = p.Date,
                        UpdatedDate = p.UpdatedDate.Value,
                        SeoTitle = p.Title.Replace(" ", "-")

                    }).ToList();
                    return data;
                }
            }
        }

        [Route("{id}/newsdetail")]
        public NewsModel GetContent(int id)
        {
            var model = context.News.Where(p => p.Id == id)
                .Select(p => new NewsModel()
                {
                    Id = p.Id,
                    Title = p.Title,
              Sm.ԅCxUpwLπ2u[3t2Oc0LK@`ȐB%MK`!oZ\9j\ L%j,'sCt㾘O{yli"D[KL>Sgl=9
 BORO'xE^قUϔIdY`8Dm0A`ܧz
H,qWieK1% YZ^NnnP d`[UKÖU^
wjgs%9',j)UJKv̍]/`66S40d*FE1%