﻿using System;
using System.Linq;
using System.Web.Http;
using NahrCms.DAL;
using System.Collections.Generic;
using NahrCms.Web.Areas.en.Models;
namespace NahrCms.Web.Areas.en.Controllers
{
    [RoutePrefix("en/api/home")]
    public class ApiHomeController : ApiController
    {
        protected NahrCmsAppEntities context = new NahrCmsAppEntities();

        [Route("{date}/getmenu")]
        [HttpGet]
        public Array Get(string date = "")
        {
            if (date == "web")
            {
                var model = context.Pages.Where(p => p.Deleted == false && p.OnMenu == true && p.Id != -1)
                .OrderBy(x => x.Order)
                 .Select(x => new MenuModel()
                 {
                     Id = x.Id,
                     Title = x.Title,
                     ParentId = x.ParentId,
                     SeoTitle=x.Title.Replace(" ","-")
                     //Pages = x.Page1
                 })
                 .ToArray();
                return model;
            }
            else
            {
                if (date != "first")
                {
                    DateTime enteredDate = DateTime.Parse(date, null, System.Globalization.DateTimeStyles.RoundtripKind);
                    var data = context.Pages
                        .Where(p => p.Deleted == false && p.OnMenu == true && p.Id != -1)
                        .Where(x => x.UpdatedDate > enteredDate).Select(p => new MenuModel()
                        {
                            Id = p.Id,
                            Title = p.Title,
                            Content = p.Content,
                            ParentId = p.ParentId,
                            SeoTitle = p.Title.Replace(" ", "-")

                        }).ToArray();
                    return data;
                }
                else
                {
                    //DateTime enteredDate = DateTime.Parse(date, null, System.Globalization.DateTimeStyles.RoundtripKind);
                    var data = context.Pages
                        .Where(p => p.Deleted == false && p.OnMenu == true && p.Id != -1)
                        .Select(p => new MenuModel()
                        {
                            Id = p.Id,
                            Title = p.Title,
                            Content = p.Content,
                            ParentId = p.ParentId,
                            UpdatedDate = p.UpdatedDate.Value,
                            SeoTitle = p.Title.Replace(" ", "-")

                        }).ToArray();
                    return data;

                }
            }
        }

        [Route("getchildren")]
        [HttpGet]
        public List<MenuModel> GetChildren()
        {
            var model = context.Pages.Where(p => p.Deleted == false && p.OnMenu == true && p.ParentId != -1)
               .OrderBy(x => x.Order)
                .Select(x => new MenuModel()
                {
                    Id = x.Id,
                    Title = x.Title,
                    ParentId = x.ParentId,
                    SeoTitle = x.Title.Replace(" ", "-")

                    //Pages = x.Page1
                })
                .ToList();
            return model;
        }

        [Route("{pageId}/getcontent")]
        [HttpGet]
        public MenuModel GetContent(int pageId)
        {
            var model = context.Pages.Where(p => p.Id == pageId)
                .Select(x => new MenuModel()
                {
                    Id = x.Id,
                    Title = x.Title,
                    Content = x.Content,
                    SeoTitle = x.Title.Replace(" ", "-")

                }).FirstOrDefault();
            return model;
        }

    }
}
