﻿using NahrCms.DAL;
using NahrCms.Web.Areas.admin.DataModels.Models.Content;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Threading.Tasks;
using System.Web;
using System.Web.Http;

namespace NahrCms.Web.Areas.en.Api
{
    [RoutePrefix("en/api/events")]
    public class ApiEventController : ApiController
    {
        protected NahrCmsAppEntities context = new NahrCmsAppEntities();
        const int recordsPerPage = 10;

        [Route("{date}/getall")]
        [HttpGet]
        public IEnumerable<EventModel> getEvents(int id = 0, string date = "", string dateFrom = "",
            string dateTo = "", int? eventCategoryId = 0)
        {
            if (date == "web")
            {
                DateTime d2;
                int month;
                int? monthFrom = null;
                int? monthTo = null;
                var skipRecords = id * recordsPerPage;
                if (int.TryParse(dateFrom, out month))
                {
                    monthFrom = Convert.ToInt32(dateFrom);
                }
                DateTime? dateTimeTo = null;
                if (int.TryParse(dateTo, out month))
                {
                    monthTo = Convert.ToInt32(dateTo);
                }
                //DateTime? dateTimeFrom = null;
                //if (DateTime.TryParse(dateFrom, out d2))
                //{
                //    dateTimeFrom = DateTime.Parse(dateFrom, null, System.Globalization.DateTimeStyles.RoundtripKind);
                //    monthFrom = dateTimeFrom.Value.Month;
                //}
                //DateTime? dateTimeTo = null;
                //if (DateTime.TryParse(dateFrom, out d2))
                //{
                //    dateTimeTo = DateTime.Parse(dateTo, null, System.Globalization.DateTimeStyles.RoundtripKind);
                //    monthTo = dateTimeTo.Value.Month;
                //}
                var query = context.Events.OrderBy(x => x.Id)
                    .Where(p => (!eventCategoryId.HasValue || p.EventCategory.Id == eventCategoryId))
                    .Where(p => (!monthFrom.HasValue || p.Date.Value.Month >= monthFrom)
                    && (!monthTo.HasValue || p.Date.Value.Month < monthTo))
                    .Select(p => new EventModel()
                    {
                        Id = p.Id,
                        Title = p.Title,
                        Description = p.Description,
                        MainPhoto = p.Image,
                        SeoTitle = p.Title.Replace(" ", "-")
                    }).Skip(skipRecords).Take(recordsPerPage);
                return query;
            }
            else
            {
                if (date != "first")
                {
                    DateTime enteredDate = DateTime.Parse(date, null, System.Globalization.DateTimeStyles.RoundtripKind);
                    var data = context.Events
                        .Where(x => x.UpdatedDate > enteredDate).Select(p => new EventModel()
                        {
                            Id = p.Id,
                            Title = p.Title,
                            Description = p.Description,
                            MainPhoto = p.Image,
                            UpdatedDate = p.UpdatedDate,
                            Date = p.Date.Value,
                            EventCategoryId = p.EventCategory.Id,
                            SeoTitle = p.Title.Replace(" ", "-")

                        }).ToList();
                    return data;
                }
                else
                {
                    var data = context.Events.Select(p => new EventModel()
                    {
                        Id = p.Id,
                        Title = p.Title,
                        Description = p.Description,
                        MainPhoto = p.Image,
                        UpdatedDate = p.UpdatedDate,
                        Date = p.Date.Value,
                        EventCategoryId = p.EventCategory.Id,
                        SeoTitle = p.Title.Replace(" ", "-")
                    }).ToList();
                    return data;
                }
            }
        }

        [Route("{date}/geteventcategory")]
        [HttpGet]
        public IEnumerable<EventCategoryModel> getEventCategories(string date = "")
        {
            
            if (date != "first")
            {
                DateTime enteredDate = DateTime.Parse(date, null, System.Globalization.DateTimeStyles.RoundtripKind);
                var data = context.EventCategories
                    .Where(x => x.UpdatedDate > enteredDate).Select(p => new EventCategoryModel()
                    {
                        Id = p.Id,
                        Title = p.Title,
                        UpdatedDate = p.UpdatedDate,
                       
                    }).ToList();
                return data;
            }
            else
            {
                var data = context.EventCategories.Select(p => new EventCategoryModel()
                {
                    Id = p.Id,
                    Title = p.Title,
                    UpdatedDate = p.UpdatedDate,
                   
                }).ToList();
                return data;
            }
        }

        //[MimeMultipart]
        [Route("{date}/upload")]
        public async Task<HttpResponseMessage> PostFormData(string date = "")
        {

            var httpRequest = HttpContext.Current.Request;
            try
            {
                #region [Working Great]
                foreach (string file in httpRequest.Files)
                {

                    var postedFile = httpRequest.Files[file];
                    var filePath = HttpContext.Current.Server.MapPath("~/Uploads/Event/" + postedFile.FileName);

                    postedFile.SaveAs(filePath);
                }
                #endregion

                return Request.CreateResponse(HttpStatusCode.OK);
            }

            catch (Exception e)
            {
                return Request.CreateErrorResponse(HttpStatusCode.InternalServerError, e);
            }
        }

    }

    public class Okkkoko
    {
        public int Id { get; set; }

    }
}
