﻿$(document).ready(function () {
    $("#btnSearch").click(function (e) {
        $('#gridView').jtable('load', {
            Email: $("#Email").val()
        });
    });
    $('#gridView').jtable({
        title: "Users List",
        paging: true,
        sorting: true,
        defaultSorting: 'Id ASC', 
        actions: {
            listAction: '/admin/Users/Search'
        },
        toolbar: {
            items: [{
                text: "Add Item",
                cssClass: 'lnkAddVendor'
            }
            ]
        },
        fields: {
            Id: {
                width: '5%',
                title: "Id"
            },
            Email: {
                width: '5%',
                title: "Email"
            }
              , Delete: {
                  title: "Delete",
                  width: '5%',
                  sorting: false,
                  display: function (data) { return $('<a class="label label-danger" href="javascript:DeleteConfirm(\'' + data.record.Id + '\')">' + "Delete" + '</a>'); }
              }

        }
    });

    $("#btnSearch").trigger("click");

    $(".lnkAddVendor").click(function () {
        $(this).css('cursor', 'pointer');
        window.location = "/Admin/Users/AddEdit";
    });
});

function DeleteConfirm(id) {

    swal({ title: "Confirm", text: "Do you want to delete the item?", type: "warning", showCancelButton: true, confirmButtonColor: "#DD6B55", confirmButtonText: "Yes", cancelButtonText: "No", closeOnConfirm: false, closeOnCancel: false }, function (isConfirm) {

        if (isConfirm) {
            //var url1 = '/WelcomeMangement/Delete?id=' + Id;
            var url1 = '/admin/Users/Delete?id=' + id;
            $.ajax({
                url: url1,
                type: 'POST',
                data: $("#frmSearch").serialize(),
                success: function (data) {
                    swal("Success", "The item was deleted successfully!", "success");
                    $("#btnSearch").trigger("click");
                }
            });
        }
        else {
            swal("Cancelled", "Deletion has been canceled!", "error");
        }
    });
}