﻿$(document).ready(function () {
    $("#btnSearch").click(function (e) {
        ;
        $('#gridView').jtable('load', {
            Title: $("#Title").val()
        });

    });


    $('#gridView').jtable({
        title: "Slider List",
        paging: true,
        sorting: true,
        defaultSorting: 'Id ASC',
        actions: {
            listAction: '/JobMangement/Search'
        },
        toolbar: {
            items: [{
                text: "Add Item",
                cssClass: 'lnkAddVendor'
            }
            ]
        },
        fields: {
            Id: {
                width: '5%',
                title: "Id"
            },
            TitleEn: {
                width: '5%',
                title: "Title English"
            },
            TitleFr: {
                width: '5%',
                title: "Title Frensh"
            },
            TitleNl: {
                width: '5%',
                title: "Title Dutch"
            }, 
            Date: {
                width: '5%',
                title: "Date",
                display: function(data) {
                    return moment(data.record.Date).format('DD/MM/YYYY');
                }
            },
            Edit: {
                title: "Edit",
                width: '5%',
                sorting: false,
                display: function (data) { return $('<a class="label label-default" href="/admin/JobMangement/AddEdit/' + data.record.Id + '">' + "Edit" + '</a>'); }
            }
              , Delete: {
                  title: "Delete",
                  width: '5%',
                  sorting: false,
                  display: function (data) { return $('<a class="label label-danger" href="javascript:DeleteConfirm(' + data.record.Id + ')">' + "Delete" + '</a>'); }
              }

        }
    });

    $("#btnSearch").trigger("click");

    $(".lnkAddVendor").click(function () {
        $(this).css('cursor', 'pointer');
        window.location = "/Admin/JobMangement/AddEdit";
    });
});

function DeleteConfirm(id) {

    swal({ title: "Confirm", text: "Do you want to delete the item?", type: "warning", showCancelButton: true, confirmButtonColor: "#DD6B55", confirmButtonText: "Yes", cancelButtonText: "No", closeOnConfirm: false, closeOnCancel: false }, function (isConfirm) {

        if (isConfirm) {
            var url1 = '/admin/JobMangement/Delete?id=' + id;
            $.ajax({
                url: url1,
                type: 'POST',
                data: $("#frmSearch").serialize(),
                success: function (data) {
                    swal("Success", "The item was deleted successfully!", "success");
                    $("#btnSearch").trigger("click");
                }
            });
        }
        else {
            swal("Cancelled", "Deletion has been canceled!", "error");
        }
    });
}