﻿$(document).ready(function () {
    $("#btnSearch").click(function (e) {
        $('#gridView').jtable('load', {
            Name: $("#Name").val()
        });
    });
    $('#gridView').jtable({
        title: "Career List",
        paging: true,
        sorting: true,
        defaultSorting: 'Id ASC', 
        actions: {
            listAction: '/admin/Career/Search'
        },
        toolbar: {
            items: [{
                text: "Add Item",
                cssClass: 'lnkAddVendor'
            }
            ]
        },
        fields: {
            Id: {
                width: '5%',
                title: "Id"
            },
            Name: {
                width: '5%',
                title: "Name"
            },
            JobTitle: {
                width: '5%',
                title: "Job Title"
            },
            Edit: {
                title: "Edit",
                width: '5%',
                sorting: false,
                display: function (data) { return $('<a class="label label-default" href="/admin/Career/AddEdit/' + data.record.Id + '">' + "Show" + '</a>'); }
            }
              , Delete: {
                  title: "Delete",
                  width: '5%',
                  sorting: false,
                  display: function (data) { return $('<a class="label label-danger" href="javascript:DeleteConfirm(' + data.record.Id + ')">' + "Delete" + '</a>'); }
              }

        }
    });

    $("#btnSearch").trigger("click");

    $(".lnkAddVendor").click(function () {
        $(this).css('cursor', 'pointer');
        window.location = "/Admin/Career/AddEdit";
    });
});

function DeleteConfirm(id) {

    swal({ title: "Confirm", text: "Do you want to delete the item?", type: "warning", showCancelButton: true, confirmButtonColor: "#DD6B55", confirmButtonText: "Yes", cancelButtonText: "No", closeOnConfirm: false, closeOnCancel: false }, function (isConfirm) {

        if (isConfirm) {
            //var url1 = '/WelcomeMangement/Delete?id=' + Id;
            var url1 = '/admin/Career/Delete?id=' + id;
            $.ajax({
                url: url1,
                type: 'POST',
                data: $("#frmSearch").serialize(),
                success: function (data) {
                    swal("Success", "The item was deleted successfully!", "success");
                    $("#btnSearch").trigger("click");
                }
            });
        }
        else {
            swal("Cancelled", "Deletion has been canceled!", "error");
        }
    });
}