﻿using FluentValidation;
using NahrCms.Web.Areas.admin.DataModels.Models.Products;

namespace NahrCms.Web.Areas.admin.DataModels.Validators
{
    public class ProductValidator : AbstractValidator<ProductModel>
    {
        public ProductValidator()
        {
            RuleFor(x => x.Title).NotEmpty().WithMessage("Title is Required");
            //RuleFor(x => x.Description).NotEmpty().WithMessage("Description is required");
            //RuleFor(x => x.ShortDescription).NotEmpty().WithMessage("Short description is required");
            RuleFor(x => x.ProductCategoryId)
               .NotNull().WithMessage("Product category required")
               .GreaterThan(0).WithMessage("Product category required");
        }
    }
}