﻿using System;
using FluentValidation;
using NahrCms.Web.Areas.admin.DataModels.Models.Content;

namespace NahrCms.Web.Areas.admin.DataModels.Validators
{
    public class NewsValidator : AbstractValidator<NewsModel>
    {
        public NewsValidator()
        {
            RuleFor(x => x.Title).NotEmpty().WithMessage("Title is required");
            RuleFor(x => x.Description).NotEmpty().WithMessage("Description is required");
            //RuleFor(x => x.Date).NotEmpty().Must(BeAValidDate).WithMessage("Date is required");

        }

        private bool BeAValidDate(DateTime date)
        {
            return !date.Equals(default(DateTime));
        }
    }
}