﻿using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Web;
using System.Web.Mvc;
using FluentValidation.Attributes;
using NahrCms.Web.Areas.admin.DataModels.Validators;
using NahrCms.Web.Areas.admin.DataModels.Models.Configuration;

namespace NahrCms.Web.Areas.admin.DataModels.Models.ShowRooms
{
    [Validator(typeof(ShowRoomValidator))]
    public class ShowRoomModel : BaseModel
    {
        public int? Id { get; set; }
        public string Title { get; set; }
        public string TitleAr { get; set; }
        [UIHint("tinymce_jquery_full"), AllowHtml]
        public string Description { get; set; }
        [UIHint("tinymce_jquery_full"), AllowHtml]
        public string DescriptionAr { get; set; }
        public string Address { get; set; }
        public bool Featured { get; set; }
        public string Latitude { get; set; }
        public string Longitude { get; set; }
        public string MainPhoto { get; set; }
        public HttpPostedFileBase MainImage { get; set; }

        public IList<ShowRoomModel> ShowRoomItems { get; set; }
        public string Header_Image { get; set; }

    }
}