﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Web;
using System.Web.Mvc;
using FluentValidation.Attributes;
using NahrCms.Web.Areas.admin.DataModels.Models.FrameWorkModels;
using NahrCms.Web.Areas.admin.DataModels.Validators;
using PagedList;
using NahrCms.DAL;
using NahrCms.Web.Areas.admin.DataModels.Models.Configuration;


namespace NahrCms.Web.Areas.admin.DataModels.Models.Projects
{
    [Validator(typeof(ProjectValidator))]
    public class ProjectModel : BaseModel
    {
        public int? Id { get; set; }
        public string Title { get; set; }
        public string TitleAr { get; set; }
        [UIHint("tinymce_jquery_full"), AllowHtml]
        public string Description { get; set; }
        [UIHint("tinymce_jquery_full"), AllowHtml]
        public string DescriptionAr { get; set; }
        public string ShortDescription { get; set; }
        public string ShortDescriptionAr { get; set; }
        public string YouTubeLink { get; set; }
        public string FeaturedProjects { get; set; }
        public string MainPhoto { get; set; }
        public HttpPostedFileBase MainImage { get; set; }
        public List<string> PhotosUpload = new List<string>();
        public string Photos { get; set; }
        public int? ProjectCategoryId { get; set; }
        public bool Featured { get; set; }
        public string ProjectCategory { get; set; }
        public List<BaseObject> ProjectCategoryList { get; set; }
        public IList<ProjectModel> PojectItems { get; set; }
        public IList<ProjectModel> PojectCategoryItems { get; set; }
        public IPagedList<Project> ListProjects { get; set; }

        public DateTime? UpdatedDate { get; set; }
        public string Header_Image { get; set; }
        public string Footer_Image { get; set; }
        public string SeoTitle { set; get; }
    }
}