﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Web;
using System.Web.Mvc;
using FluentValidation.Attributes;
using NahrCms.Web.Areas.admin.DataModels.Models.FrameWorkModels;
using NahrCms.Web.Areas.admin.DataModels.Validators;
using PagedList;
using NahrCms.DAL;
using NahrCms.Web.Areas.admin.DataModels.Models.Configuration;

namespace NahrCms.Web.Areas.admin.DataModels.Models.Products
{
    [Validator(typeof(ProductValidator))]
    public class ProductModel : BaseModel
    {
        public ProductModel()
        {
            ProductItems = new List<productRequred>();
            productList = new List<SelectListItem>();
        }
        public int Applicationen { get; set; }
        public List<SelectListItem> productList { get; set; }
        public int? Id { get; set; }
        public string Title { get; set; }
        public string TitleFr { get; set; }
        public string TitleNl { get; set; }
        [UIHint("tinymce_jquery_full"), AllowHtml]
        public string Description { get; set; }
        [UIHint("tinymce_jquery_full"), AllowHtml]
        public string DescriptionFr { get; set; }
        [UIHint("tinymce_jquery_full"), AllowHtml]
        public string DescriptionNl { get; set; }
        public string ShortDescription { get; set; }
        public string ShortDescriptionFr { get; set; }
        public string ShortDescriptionNl { get; set; }
        public string YouTubeLink { get; set; }
        public string FeaturedProjects { get; set; }
        public string MainPhoto { get; set; }
        public HttpPostedFileBase MainImage { get; set; }
        public List<string> PhotosUpload = new List<string>();
        public string Photos { get; set; }
        public int? ProductCategoryId { get; set; }
        public bool Featured { get; set; }
        public string ProductCategory { get; set; }

        public List<BaseObject> ProductCategoryList { get; set; }
        public IList<productRequred> ProductItems { get; set; }
        public IList<ProductModel> ProductCategoryItems { get; set; }

        public IPagedList<Product> ListProducts { get; set; }

        public string Header_Image { get; set; }
        public string Footer_Image { get; set; }
        public DateTime? UpdatedDate { get; set; }
        public string SeoTitle { set; get; }
    }
    public class productRequred
    {
        public string MainPhoto { get; set; }
        public string Title { get; set; }
        public int Id { get; set; }
        public int ProductCategoryId { get; set; }
    }
}