﻿using System.ComponentModel.DataAnnotations;
using System.Web;
using System.Web.Mvc;
using FluentValidation.Attributes;
using NahrCms.Web.Areas.admin.DataModels.Validators;
using NahrCms.Web.Areas.admin.DataModels.Models.Configuration;
using NahrCms.Web.Areas.admin.DataModels.Models.FrameWorkModels;
using System.Collections.Generic;

namespace NahrCms.Web.Areas.admin.DataModels.Models.Products
{
    [Validator(typeof(ProductCategoryValidator))]
    public class ProductCategoryModel : BaseModel
    {
        public int? Id { get; set; }
        public string Title { get; set; }
        public string TitleFr { get; set; }
        public string TitleNl { get; set; }
        [UIHint("tinymce_jquery_full"), AllowHtml]
        public string Description { get; set; }
        [UIHint("tinymce_jquery_full"), AllowHtml]
        public string DescriptionFr { get; set; }
        [UIHint("tinymce_jquery_full"), AllowHtml]
        public string DescriptionNl { get; set; }
        public string ShortDescription { get; set; }
        public string ShortDescriptionFr { get; set; }
        public string ShortDescriptionNl { get; set; }
        public string MainPhoto { get; set; }
        public HttpPostedFileBase MainImage { get; set; }
        public string Image { get; set; }
        public int? ParentId { get; set; }
        public List<BaseObject> ProductCategoryList { get; set; }


    }
}