﻿using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Web;
using System.Web.Mvc;
using FluentValidation.Attributes;
using NahrCms.Web.Areas.admin.DataModels.Validators;
using NahrCms.Web.Areas.admin.DataModels.Models.FrameWorkModels;
using NahrCms.Web.Areas.admin.DataModels.Models.Products;
using NahrCms.Web.Areas.admin.DataModels.Models.Configuration;

namespace NahrCms.Web.Areas.admin.DataModels.Models.Materials
{
    [Validator(typeof(MaterialValidator))]
    public class MaterialModel : BaseModel
    {

        public int? Id { get; set; }
        public string Title { get; set; }
        public string TitleAr { get; set; }
        public string Address { get; set; }
        public string Color { get; set; }
        public string Type { get; set; }
        [UIHint("tinymce_jquery_full"), AllowHtml]
        public string Description { get; set; }
        [UIHint("tinymce_jquery_full"), AllowHtml]
        public string DescriptionAr { get; set; }

        public string MainPhoto { get; set; }
        public HttpPostedFileBase MainImage { get; set; }
        public List<string> PhotosUpload = new List<string>();
        public string Photos { get; set; }
        public int? ProductId { get; set; }
        public List<BaseObject> ProductList { get; set; }
        public IList<MaterialModel> MaterialsItems { get; set; }
        public string Header_Image { get; set; }
        public string Footer_Image { get; set; }
        public IList<ProductModel> ProductItemList { get; set; }
    }
}