﻿using System.Collections.Generic;
using MvcContrib.Pagination;
using MvcContrib.UI.Grid;

namespace NahrCms.Web.Areas.admin.DataModels.Models.FrameWorkModels
{
    public class PagedViewModel<T>
    {
        public IPagination<T> CustomPageList
        {
            get;
            set;
        }

        /// <summary>
        ///  Grid Sort Options
        /// </summary>
        public GridSortOptions GridSortOptions
        {
            get;
            set;
        }
        public int IndexOf(T element, IEqualityComparer<T> comparer = null)
        {
            int i = 0;
            comparer = comparer ?? EqualityComparer<T>.Default;
            foreach (var currentElement in this.CustomPageList)
            {
                if (comparer.Equals((currentElement), element))
                {
                    return i;
                }

                i++;
            }

            return -1;
        }
    }
}