﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Web;
using System.Web.Mvc;
using NahrCms.Web.Areas.admin.DataModels.Models.FrameWorkModels;
using NahrCms.Web.Areas.admin.DataModels.Validators;
using FluentValidation.Attributes;
using NahrCms.Web.Areas.admin.DataModels.Models.PhotoGallery;
using NahrCms.Web.Areas.admin.DataModels.Models.Configuration;

namespace NahrCms.Web.Areas.admin.DataModels.Models.Content
{
    [Validator(typeof(NewsValidator))]
    public class NewsModel : BaseModel
    {
        public string pageTitle { get; set; }
        public int? Id { get; set; }
        public string Title { get; set; }
        public string TitleAr { get; set; }
        public string TitleFr { get; set; }
        public string TitleNl { get; set; }
        [UIHint("tinymce_jquery_full"), AllowHtml]
        public string Description { get; set; }
        [UIHint("tinymce_jquery_full"), AllowHtml]
        public string DescriptionFr { get; set; }
        [UIHint("tinymce_jquery_full"), AllowHtml]
        public string DescriptionNl { get; set; }
        public string MainPhoto { get; set; }
        public HttpPostedFileBase MainImage { get; set; }
        public int? PhotoGalleryId { get; set; }
        public bool Featured { get; set; }
        public DateTime Date { get; set; }

        public List<BaseObject> PhotoGalleryList { get; set; }
        public List<Item> Photos { set; get; }

        public IList<NewsModel> NewsItems { get; set; }
        public List<string> PhotosUpload = new List<string>();

        public DateTime? UpdatedDate { get; set; }
        public string Header_Image { get; set; }
        public string SeoTitle { set; get; }
        public string LogisticsTitle { set; get; }
        public string LogisticsDecrition { set; get; }
        public string risksTitle { set; get; }
        public string risksDecrition { set; get; }
        public string qualityTitle { set; get; }
        public string qualityDecrition { set; get; }
        public string qualityTitle1 { set; get; }
        public string qualityDecrition1 { set; get; }
        public string qualityTitle2 { set; get; }
        public string qualityDecrition2 { set; get; }
        public string qualityTitle3 { set; get; }
        public string qualityDecrition3 { set; get; }
        public string qualityTitle4 { set; get; }
        public string qualityDecrition4 { set; get; }
        public string MisionTitle { get; set; }
        public string MisionDescription { get; set; }
        public string VisionTitle { get; set; }
        public string VisionDescription { get; set; }
    }
}