﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Web;
using System.Web.Mvc;
using FluentValidation.Attributes;
using NahrCms.Web.Areas.admin.DataModels.Models.FrameWorkModels;
using NahrCms.Web.Areas.admin.DataModels.Validators;
using PagedList;
using NahrCms.DAL;
using NahrCms.Web.Areas.admin.DataModels.Models.PhotoGallery;
using NahrCms.Web.Areas.admin.DataModels.Models.Configuration;

namespace NahrCms.Web.Areas.admin.DataModels.Models.Content
{
    [Validator(typeof(EventValidator))]
    public class EventModel : BaseModel
    {
        public int? Id { get; set; }
        public string Title { get; set; }
        public string TitleAr { get; set; }
        [UIHint("tinymce_jquery_full"), AllowHtml]
        public string Description { get; set; }
        [UIHint("tinymce_jquery_full"), AllowHtml]
        public string DescriptionAr { get; set; }
        public string MainPhoto { get; set; }
        public HttpPostedFileBase MainImage { get; set; }
        public int? PhotoGalleryId { get; set; }
        public int? EventCategoryId { get; set; }
        public DateTime Date { get; set; }

        public List<BaseObject> PhotoGalleryList { get; set; }
        public List<Item> Photos { set; get; }

        public List<BaseObject> EventCategoryList { get; set; }
        public IList<EventModel> EventItems { get; set; }
        public IPagedList<Event> ListEvents { get; set; }
        public IList<EventModel> EventCategoryItems { get; set; }

        public string DateListFrom { get; set; }
        public string DateListTo { get; set; }

        public DateTime? UpdatedDate { get; set; }
        public string Header_Image { get; set; }
        public string Footer_Image { get; set; }
        public string SeoTitle { set; get; }

    }
}