﻿using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Web.Mvc;
using FluentValidation.Attributes;
using NahrCms.Web.Areas.admin.DataModels.Models.FrameWorkModels;
using NahrCms.Web.Areas.admin.DataModels.Validators;
using NahrCms.DAL;

namespace NahrCms.Web.Areas.admin.DataModels.Models.Configuration
{
    [Validator(typeof(PageValidator))]
    public class PageModel : BaseModel
    {
        public int? Id { get; set; }
        public string Title { get; set; }
        public string TitleAr { get; set; }
        public int? Order { get; set; }
        public bool OnMenu { get; set; }
        [AllowHtml]
        public string Content { get; set; }
        [AllowHtml]
        public string ContentAr { get; set; }
        public int? ParentId { get; set; }

        public string MetaTitle { get; set; }
        public string MetaDescription { get; set; }
        public string MetaKeyword { get; set; }
        public IList<PageModel> Pages;
        public List<BaseObject> PagesList { get; set; }
        [System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Usage", "CA2227:CollectionPropertiesShouldBeReadOnly")]
        public virtual ICollection<Page> Page1 { get; set; }
        public virtual Page Page2 { get; set; }
    }
}