﻿using System.Collections.Generic;
using System.Linq;
using System.Web.Mvc;
using NahrCms.DAL;
using NahrCms.Web.Areas.admin.DataModels.Models.Configuration;
using NahrCms.Web.Helpers.Notification;

namespace NahrCms.Web.Areas.admin.Controllers
{
    [Authorize]

    public class WelcomeMangementController : BaseController
    {
        public ActionResult Index()
        {
            WelcomeModel model = new WelcomeModel();
            AdminSetting(model);
            return View(model);
        }

        [HttpPost]
        public JsonResult Search(string Title, int jtStartIndex = 0, int jtPageSize = 10, string jtSorting = null)
        {
            var query = context.Welcomes.Where(p => (string.IsNullOrEmpty(Title)
                                                     || p.Title.ToLower().Contains(Title.ToLower())));
            var count = query.Count();
            List<Welcome> list = new List<Welcome>();
            if (jtSorting.Equals("Id ASC"))
            {
                list = query.OrderBy(item => item.Id).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }
            else if (jtSorting.Equals("Id DESC"))
            {
                list = query.OrderByDescending(item => item.Id).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }
            else if (jtSorting.Equals("Title ASC"))
            {
                list = query.OrderBy(item => item.Title).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }

            else if (jtSorting.Equals("Title DESC"))
            {
                list = query.OrderByDescending(item => item.Title).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }

            return Json(new { Result = "OK", Records = list, TotalRecordCount = count });
        }

        public ActionResult AddEdit(int? Id)
        {
            WelcomeModel model = new WelcomeModel();
            AdminSetting(model);
            if (Id.HasValue && Id.Value > 0)
            {
               Welcome p = context.Welcomes.Where(x => x.Id == Id.Value).FirstOrDefault();

                model.Id = p.Id;
                model.Title = p.Title;
                model.TitleAr = p.TitleAr;
                model.Content = p.Content;
                model.ContentAr = p.ContentAr;
               

            }
            
            return View(model);
        }
        [HttpPost]
        public ActionResult AddEditAr(WelcomeModel model)
        {
            Welcome obj = context.Welcomes.Where(p => p.Id == model.Id).FirstOrDefault();

            obj.TitleAr = model.TitleAr;
            obj.ContentAr = model.ContentAr;
          

            context.SaveChanges();
           // AddToastMessage("Success", "Product updated successfully", ToastType.Success);
            return RedirectToAction("/Index");
        }
        [HttpPost]
        [ValidateInput(false)]
        public ActionResult AddEdit(WelcomeModel model)
        {
            if (ModelState.IsValid)
            {
                Welcome obj = null;
                if (model.Id > 0)
                {
                    obj = context.Welcomes.Where(p => p.Id == model.Id).FirstOrDefault();
                }
                else 
                    obj = new Welcome();
                obj.Title = model.Title;
                obj.TitleAr = model.TitleAr;
                obj.Content = model.Content;
                obj.ContentAr = model.ContentAr;

                if (obj.Id == 0)
                {
                    context.Welcomes.Add(obj);
                    context.SaveChanges();
                    this.AddToastMessage("Success", "Welcome Added Successfully", ToastType.Success);
                }
                else
                {
                    context.SaveChanges();
                    this.AddToastMessage("Success", "Welcome Edited Successfully", ToastType.Success);
                }

                return RedirectToAction("/Index");
            }
         //   AddToastMessage("Error", "Check Your form", ToastType.Error);
            return View(model);
        }

        public ActionResult Delete(int id)
        {
            var obj = context.Welcomes.Find(id);
            context.Welcomes.Remove(obj);
            context.SaveChanges();
            return Json(new { Result = true, data = obj }, JsonRequestBehavior.AllowGet);

        }
    }
}