﻿using System;
using System.Globalization;
using System.Linq;
using System.Security.Claims;
using System.Threading.Tasks;
using System.Web;
using System.Web.Mvc;
using Microsoft.AspNet.Identity;
using Microsoft.AspNet.Identity.Owin;
using Microsoft.Owin.Security;
using System.Collections.Generic;
using System.Data.Entity;
using System.IO;
using NahrCms.Web.Models;
using NahrCms.Web.Areas.admin.DataModels.Models;
using NahrCms.DAL;

namespace NahrCms.Web.Areas.admin.Controllers
{
    [Authorize]
    public class UsersController : BaseController
    {
        private ApplicationSignInManager _signInManager;
        private ApplicationUserManager _userManager;

        public UsersController()
        {
        }

        public UsersController(ApplicationUserManager userManager, ApplicationSignInManager signInManager)
        {
            UserManager = userManager;
            SignInManager = signInManager;
        }

        public ApplicationSignInManager SignInManager
        {
            get
            {
                return _signInManager ?? HttpContext.GetOwinContext().Get<ApplicationSignInManager>();
            }
            private set
            {
                _signInManager = value;
            }
        }

        public ApplicationUserManager UserManager
        {
            get
            {
                return _userManager ?? HttpContext.GetOwinContext().GetUserManager<ApplicationUserManager>();
            }
            private set
            {
                _userManager = value;
            }
        }
        public ActionResult Index()
        {
            UsersModel model = new UsersModel();
            AdminSetting(model);
            return View(model);
        }
        [HttpPost]
        public JsonResult Search(string Email, int jtStartIndex = 0, int jtPageSize = 20, string jtSorting = null)
        {
            AspNetRole hr = context.AspNetRoles.Where(c => c.Name == "hr").FirstOrDefault();
            var query = context.AspNetUsers.Where(p => 
            (string.IsNullOrEmpty(Email) || p.Email.ToLower().Contains(Email.ToLower())))
            .Where(p=>p.AspNetRoles.FirstOrDefault().Name == "hr")
            .Select(p => new UsersModel
                                                     {
                                                         Id = p.Id,
                                                         Email = p.Email
                                                     }); ;
            var count = query.Count();
            List<UsersModel> list = new List<UsersModel>();
            if (jtSorting.Equals("Id ASC"))
            {
                list = query.OrderBy(item => item.Id).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }
            else if (jtSorting.Equals("Id DESC"))
            {
                list = query.OrderByDescending(item => item.Id).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }
            else if (jtSorting.Equals("Title ASC"))
            {
                list = query.OrderBy(item => item.Email).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }

            else if (jtSorting.Equals("Title DESC"))
            {
                list = query.OrderByDescending(item => item.Email).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }

            return Json(new { Result = "OK", Records = list, TotalRecordCount = count });
        }
        public ActionResult Delete(string id)
        {
            var obj = context.AspNetUsers.Where(f => f.Id == id)
              .FirstOrDefault();
            context.AspNetUsers.Remove(obj);
            context.SaveChanges();
            return Json(new { Result = true, data = obj }, JsonRequestBehavior.AllowGet);

        }
        public ActionResult AddEdit(string Id)
        {
            UsersModel model = new UsersModel();
            AspNetUser obj = new AspNetUser();
            if (!string.IsNullOrEmpty(Id))
            {
                obj = context.AspNetUsers.Where(f => f.Id == Id)
                   .FirstOrDefault();
            }
            model.Email = obj.Email;
            model.password = obj.PasswordHash;
            return View(model);

        }
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult AddEdit(UsersModel model)
        {
            if (ModelState.IsValid)
            {
                if (string.IsNullOrEmpty(model.Id))
                {
                    var user = new ApplicationUser
                    {
                        Email = model.Email,
                        UserName = model.Email
                    };
                    var emailraw = context.AspNetUsers.Where(c => c.Email.ToLower() == model.Email.ToLower()).FirstOrDefault();
                    if (emailraw != null)
                    {
                        ModelState.AddModelError("EmailFound", "Email Found");
                        return View(model);
                    }
                    var result = UserManager.Create(user, model.password);
                    if (result.Succeeded)
                    {
                        UserManager.AddToRole(user.Id, "hr");
                        return RedirectToAction("Index", "Users");
                    }
                    else
                    {
                        ModelState.AddModelError("errormsg", result.Errors.FirstOrDefault());
                    }
                }
                else
                {
                    var obj = context.AspNetUsers
                        .Where(f => f.Id == model.Id).FirstOrDefault();

                    //if (model.Email != obj.Email)
                    //{
                    //    if (context.AspNetUsers.Where(c => c.Email == model.Email) != null)
                    //    {
                    //        TempData["Error"] = "Email found";
                    //        return View(model);
                    //    }
                    //}
                    obj.Email = model.Email;
                    context.SaveChanges();
                    return RedirectToAction("Index", "Users");
                }
            }
            return View(model);
        }
    }
}