﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.IO;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using NahrCms.DAL;
using NahrCms.Web.Areas.admin.DataModels.Models.Content;
using NahrCms.Web.Areas.admin.DataModels.Models.FrameWorkModels;
using NahrCms.Web.Helpers.Notification;

namespace NahrCms.Web.Areas.admin.Controllers
{
    public class SupportsController : BaseController
    {
        public ActionResult Index()
        {
            SupportModel model = new SupportModel();
            AdminSetting(model);
            return View(model);
        }

        [HttpPost]
        public JsonResult Search(string Title, int jtStartIndex = 0, int jtPageSize = 20, string jtSorting = null)
        {
            var query = context.Supports.Where(p => (string.IsNullOrEmpty(Title)
                                                       || p.TitleEn.ToLower().Contains(Title.ToLower()))).Select(p => new SupportModel
                                                       {
                                                           Id = p.Id,
                                                           Title = p.TitleEn,
                                                           Date = p.CreatedOn
                                                       });
            var count = query.Count();
            List<SupportModel> list = new List<SupportModel>();
            if (jtSorting.Equals("Id ASC"))
            {
                list = query.OrderBy(item => item.Id).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }
            else if (jtSorting.Equals("Id DESC"))
            {
                list = query.OrderByDescending(item => item.Id).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }
            else if (jtSorting.Equals("Title ASC"))
            {
                list = query.OrderBy(item => item.Title).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }

            else if (jtSorting.Equals("Title DESC"))
            {
                list = query.OrderByDescending(item => item.Title).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }
            else if (jtSorting.Equals("Date ASC"))
            {
                list = query.OrderBy(item => item.Date).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }

            else if (jtSorting.Equals("Date DESC"))
            {
                list = query.OrderByDescending(item => item.Date).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }
            return Json(new { Result = "OK", Records = list, TotalRecordCount = count, JsonRequestBehavior.AllowGet });
        }

        public ActionResult AddEdit(int? id)
        {
            SupportModel model = new SupportModel();

            if (id.HasValue && id.Value > 0)
            {
                Support p = context.Supports.Where(d => d.Id == id).FirstOrDefault();
                model.Id = p.Id;
                model.Title = p.TitleEn;
                model.Description = p.Description;
                //model.Date = p.Date;
            }
            else
            {
                model = new SupportModel();
                var date = DateTime.Now;
                model.Date = date.Date;
            }
            AdminSetting(model);
            return View(model);
        }

        [HttpPost]
        public ActionResult AddEditFr(SupportModel model)
        {
            Support obj = context.Supports.Where(p => p.Id == model.Id).FirstOrDefault();
                
            obj.TitleFr = model.TitleFr;
            obj.DescriptionFr = model.DescriptionFr;


            context.SaveChanges();
            AddToastMessage("Success", "Product updated successfully", ToastType.Success);
            return RedirectToAction("/Index");
        }
        [HttpPost]
        public ActionResult AddEditNl(SupportModel model)
        {
            Support obj = context.Supports.Where(p => p.Id == model.Id).FirstOrDefault();

            obj.TitleNl = model.TitleNl;
            obj.DescriptionNl = model.DescriptionNl;

            context.SaveChanges();
            AddToastMessage("Success", "Product updated successfully", ToastType.Success);
            return RedirectToAction("/Index");
        }
        [HttpPost]
        public ActionResult AddEdit(SupportModel model, IEnumerable<HttpPostedFileBase> files)
        {
            if (ModelState.IsValid)
            {
                Support obj = null;
                if (model.Id > 0)
                {
                    obj = context.Supports.Where(p => p.Id == model.Id).FirstOrDefault();
                }
                else
                    obj = new Support();
                obj.TitleEn = model.Title;
                obj.Description = model.Description;
               
                obj.CreatedOn = DateTime.Now;

                if (obj.Id == 0)
                {
                    context.Supports.Add(obj);
                    context.SaveChanges();
                    TempData["Delete"] = "Delete";
                    this.AddToastMessage("Success", "Supports Added Successfully", ToastType.Success);
                    return RedirectToAction("/Index");
                }
                else
                {
                    context.SaveChanges();
                    this.AddToastMessage("Success", "Supports Edited Successfully", ToastType.Success);
                }
                //return RedirectToAction("AddEdit", new { id = obj.Id });
                return RedirectToAction("/Index");
            }
            var modelErrors = new List<string>();
            foreach (var modelState in ModelState.Values)
            {
                foreach (var modelError in modelState.Errors)
                {
                    modelErrors.Add(modelError.ErrorMessage);
                    AddToastMessage("Error", modelError.ErrorMessage, ToastType.Error);
                }
            }
            return View(model);
        }

        public ActionResult Delete(int id)
        {
            var obj = context.Supports.Find(id);
            context.Supports.Remove(obj);
            context.SaveChanges();
            return Json(new { Result = true, data = obj }, JsonRequestBehavior.AllowGet);

        }
    }
}
