﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Web.Mvc;
using NahrCms.DAL;
using NahrCms.Web.Areas.admin.DataModels.Models.Configuration;
using NahrCms.Web.Helpers;
using NahrCms.Web.Helpers.Notification;
using NahrCms.Web.Models;

namespace NahrCms.Web.Areas.admin.Controllers
{
    [Authorize]
    public class SliderMangementController : BaseController
    {
        public ActionResult Index()
        {
            SliderModel model = new SliderModel();
            AdminSetting(model);
            return View(model);
        }
        [HttpPost]
        public JsonResult Search(string Title, int jtStartIndex = 0, int jtPageSize = 20, string jtSorting = null)
        {
            var query = context.Rotators.Where(p => (string.IsNullOrEmpty(Title)
                                                     | p.Title.ToLower().Contains(Title.ToLower())
                                                     || p.TitleFr.ToLower().Contains(Title.ToLower()) || p.TitleNl.ToLower().Contains(Title.ToLower())));
            var count = query.Count();
            List<Rotator> list = new List<Rotator>();
            if (jtSorting.Equals("Id ASC"))
            {
                list = query.OrderBy(item => item.Id).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }
            else if (jtSorting.Equals("Id DESC"))
            {
                list = query.OrderByDescending(item => item.Id).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }
            else if (jtSorting.Equals("Title ASC"))
            {
                list = query.OrderBy(item => item.Title).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }

            else if (jtSorting.Equals("Title DESC"))
            {
                list = query.OrderByDescending(item => item.Title).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }

            return Json(new { Result = "OK", Records = list, TotalRecordCount = count });
        }
        public ActionResult AddEdit(int? Id)
        {
            SliderModel model = new SliderModel();
            AdminSetting(model);
            if (Id.HasValue && Id.Value > 0)
            {
                Rotator p = context.Rotators.Where(x => x.Id == Id.Value).FirstOrDefault();

                model.Id = p.Id;
                model.Title = p.Title;
                model.TitleFr = p.TitleFr;
                model.TitleNl = p.TitleNl;
                model.Description = p.Description;
                model.DescriptionFr = p.DescriptionFr;
                model.DescriptionNl = p.DescriptionNl;
                model.Order = p.Order;
                model.Image = p.Photo;
                model.Link = p.Link;
                model.YoutubeLink = p.YoutubeLink;


            }

            return View(model);
        }

        [HttpPost]
        public ActionResult AddEditFr(SliderModel model)
        {
            Rotator obj = context.Rotators.Where(p => p.Id == model.Id).FirstOrDefault();

            obj.TitleFr = model.TitleFr;
            obj.DescriptionFr = model.DescriptionFr;

            context.SaveChanges();
            AddToastMessage("Success", "Product updated successfully", ToastType.Success);
            return RedirectToAction("/Index");
        }
        [HttpPost]
        public ActionResult AddEditNl(SliderModel model)
        {
            Rotator obj = context.Rotators.Where(p => p.Id == model.Id).FirstOrDefault();

            obj.TitleNl = model.TitleNl;
            obj.DescriptionNl = model.DescriptionNl;

            context.SaveChanges();
            AddToastMessage("Success", "Product updated successfully", ToastType.Success);
            return RedirectToAction("/Index");
        }
        [HttpPost]
        public ActionResult AddEdit(SliderModel model)
        {
            if (ModelState.IsValid)
            {
                if (model.Photo == null && String.IsNullOrEmpty(model.YoutubeLink) && String.IsNullOrEmpty(model.Image))
                {
                    AddToastMessage("Error", "YouTube Or Image are required", ToastType.Error);
                    return View(model);
                }
                Rotator obj = null;
                if (model.Id > 0)
                {
                    obj = context.Rotators.Where(p => p.Id == model.Id).FirstOrDefault();
                }
                else
                    obj = new Rotator();
                obj.Title = model.Title;
                obj.Description = model.Description;
                obj.Order = model.Order;
                if (model.Photo != null && model.Photo.ContentLength > 0)
                {
                    var Dstream = model.Photo.InputStream;
                    var DfileName = Path.GetFileName(model.Photo.FileName);
                    var DfilePath = string.Format("/Uploads/Slider/{0}", DfileName);
                    model.Photo.SaveAs(Server.MapPath(DfilePath));
                    obj.Photo = DfileName;
                }
                obj.YoutubeLink = model.YoutubeLink;
                obj.Link = model.Link;

                if (obj.Id == 0)
                {
                    context.Rotators.Add(obj);
                    context.SaveChanges();
                    this.AddToastMessage("Success", "Rotator Added Successfully", ToastType.Success);
                }
                else
                {
                    context.SaveChanges();
                    this.AddToastMessage("Success", "Rotator Edited Successfully", ToastType.Success);
                }

                return RedirectToAction("/Index");
            }
            AddToastMessage("Error", "Check Your from", ToastType.Error);
            return View(model);
        }
        public ActionResult Delete(int id)
        {
            var obj = context.Rotators.Find(id);
            context.Rotators.Remove(obj);
            context.SaveChanges();
            return Json(new { Result = true, data = obj }, JsonRequestBehavior.AllowGet);

        }
    }
}