﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Web.Mvc;
using NahrCms.DAL;
using NahrCms.Web.Areas.admin.DataModels.Models.ShowRooms;
using NahrCms.Web.Helpers.Notification;

namespace NahrCms.Web.Areas.admin.Controllers
{

    public class ShowRoomMangementController : BaseController
    {
        public ActionResult Index()
        {
            ShowRoomModel model = new ShowRoomModel();
            AdminSetting(model);
            return View(model);
        }
        [HttpPost]
        public JsonResult Search(string Title, int jtStartIndex = 0, int jtPageSize = 20, string jtSorting = null)
        {
            var query = context.ShowRooms.Where(p => (string.IsNullOrEmpty(Title)
                                                     || p.Title.ToLower().Contains(Title.ToLower()))).
                                                     Select(p => new ShowRoomModel
                                                     {
                                                         Id = p.Id,
                                                         Title = p.Title
                                                     }); ;
            var count = query.Count();
            List<ShowRoomModel> list = new List<ShowRoomModel>();
            if (jtSorting.Equals("Id ASC"))
            {
                list = query.OrderBy(item => item.Id).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }
            else if (jtSorting.Equals("Id DESC"))
            {
                list = query.OrderByDescending(item => item.Id).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }
            else if (jtSorting.Equals("Title ASC"))
            {
                list = query.OrderBy(item => item.Title).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }

            else if (jtSorting.Equals("Title DESC"))
            {
                list = query.OrderByDescending(item => item.Title).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }

            return Json(new { Result = "OK", Records = list, TotalRecordCount = count });
        }
        public ActionResult AddEdit(int? id)
        {
            ShowRoomModel model = new ShowRoomModel();
            AdminSetting(model);
            if (id.HasValue && id.Value > 0)
            {
                ShowRoom p = context.ShowRooms.Where(x => x.Id == id.Value).FirstOrDefault();

                model.Id = p.Id;
                model.Title = p.Title;
                model.TitleAr = p.TitleAr;
                model.Description = p.Description;
                model.DescriptionAr = p.DescriptionAr;
                model.Latitude = p.Latitude;
                model.Longitude = p.Longitude;
                model.Address = p.Address;
                model.Featured = p.Featured;
                model.MainPhoto = p.Image;
               

               
            }
            if (String.IsNullOrEmpty(model.Latitude) || String.IsNullOrEmpty(model.Longitude))
            {
                model.Latitude = "30.0500";
                model.Longitude = "31.2333";
            }
            return View(model);
        }
        [HttpPost]
        public ActionResult AddEdit(ShowRoomModel model)
        {
            if (ModelState.IsValid)
            {
                if (model.MainImage == null)
                {
                    if (String.IsNullOrEmpty(model.MainPhoto))
                    {
                        AddToastMessage("Error", "Image are required", ToastType.Error);
                        return View(model);
                    }
                }
                ShowRoom obj = null;
                if (model.Id > 0)
                {
                    obj = context.ShowRooms.Where(p => p.Id == model.Id).FirstOrDefault();
                }
                else
                    obj = new ShowRoom();
                obj.Title = model.Title;
               // obj.TitleAr = model.TitleAr;
                obj.Description = model.Description;
              //  obj.DescriptionAr = model.DescriptionAr;
                obj.Longitude = model.Longitude;
                obj.Latitude = model.Latitude;
                obj.Featured = model.Featured;
                obj.Address = model.Address;
                if (model.MainImage != null && model.MainImage.ContentLength > 0)
                {
                    var Dstream = model.MainImage.InputStream;
                    var DfileName = Path.GetFileName(model.MainImage.FileName);
                    var DfilePath = string.Format("/Uploads/ShowRooms/{0}", DfileName);
                    model.MainImage.SaveAs(Server.MapPath(DfilePath));
                    obj.Image = DfileName;
                }
                if (obj.Id == 0)
                {
                    context.ShowRooms.Add(obj);
                    context.SaveChanges();
                    this.AddToastMessage("Success", "ShowRoom Added Successfully", ToastType.Success);
                }
                else
                {
                    context.SaveChanges();
                    this.AddToastMessage("Success", "ShowRoom Edited Successfully", ToastType.Success);
                }

                return RedirectToAction("/Index");
            }

            var modelErrors = new List<string>();
            foreach (var modelState in ModelState.Values)
            {
                foreach (var modelError in modelState.Errors)
                {
                    modelErrors.Add(modelError.ErrorMessage);
                    AddToastMessage("Error", modelError.ErrorMessage, ToastType.Error);
                }
            }
            if (model.MainImage == null)
            {
                if (String.IsNullOrEmpty(model.MainPhoto))
                {
                    AddToastMessage("Error", "Image are required", ToastType.Error);
                    modelErrors.Add("Image are required");
                }
            }
            //AddToastMessage("Error", string.Join("<br />", modelErrors.ToArray()), ToastType.Error);
            return View(model);
        }
        [HttpPost]
        public ActionResult AddEditAr(ShowRoomModel model)
        {
            ShowRoom obj = context.ShowRooms.Where(p => p.Id == model.Id).FirstOrDefault();

            obj.TitleAr = model.TitleAr;
            obj.DescriptionAr = model.DescriptionAr;
         

            context.SaveChanges();
            AddToastMessage("Error", "Product updated successfully", ToastType.Success);
            return RedirectToAction("/Index");
        }
        public ActionResult SetLocation(string longitude, string latitude, int? Index)
        {
            GoogleMapModel model = new GoogleMapModel();

            if (longitude == "" || latitude == "")
            {
                model.LatitudeNo = "30.0500";
                model.LongitudeNo = "31.2333";
            }
            else
            {
                model.LatitudeNo = latitude;
                model.LongitudeNo = longitude;
            }
            model.Index = Index;
            return View(model);
        }

        public ActionResult Delete(int id)
        {
            if (id != null)
            {
                try
                {
                    var showroom = context.ShowRooms.Where(p => p.Id == id).FirstOrDefault();
                    context.ShowRooms.Remove(showroom);
                    context.SaveChanges();
                    AddToastMessage("Error", "showroom removed successfully", ToastType.Error);
                    return RedirectToAction("/Index");
                }
                catch
                {
                    AddToastMessage("Error", "something went wrong ", ToastType.Error);
                    return RedirectToAction("/Index");
                }

            }
            AddToastMessage("Error", "something went wrong ", ToastType.Error);
            return RedirectToAction("/Index");
        }
    }
}