﻿using NahrCms.DAL;
using NahrCms.Web.Areas.admin.DataModels.Models.Settings;
using NahrCms.Web.Helpers.Notification;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace NahrCms.Web.Areas.admin.Controllers
{
    [Authorize]
    public class SettingController : BaseController
    {
        // GET: admin/Setting
        public ActionResult Index()
        {
            SettingModel model = new SettingModel();

            
                Setting p = context.Settings.Where(d => d.Id == 1).FirstOrDefault();
                model.id = p.Id;
                model.SMTP = p.SMTP;
                model.UserName = p.UserName;
                model.email = p.Email;
                model.Password = p.Password;
                model.Authentication = p.Authentication.Value;
                model.Photo = p.Image;
                model.GoogleAnalytic = p.GoogleAnalytic;
                model.headerImage = p.Header_Photo;
                model.Materials_Footer = p.Material_Footer;
                model.Product_Footer = p.Product_Footer;
                model.Project_Footer = p.Project_Footer;
                model.Welcome_Footer = p.Welcome_Footer;
                model.Events_Footer = p.Event_Footer;
                model.Gallery_Footer = p.Gallery_Footer;
                model.FacebookURL = p.FaceBookURL;
            model.TwitterURL = p.TwitterURL;
            model.GoogleURL = p.GoogleURL;
            model.LinkedInURL = p.LinkedInURL;
            model.YouTubeURL = p.YouTubeURL;
            model.Address = p.Address;
            model.ArAddress = p.ArAddress;
            model.ENCompanyName = p.EnCompanyName;
            model.ArComapnyName = p.ArCompanyName;
            model.CompanyPhone = p.CompanyPhone.ToString();
            model.ShowFooterIamges = p.ShowFooterImages.Value;
            model.ShowHeaderIamges = p.ShowHeaderImages.Value;
            //if (p.ShowAboutUs!=null)
            //model.ShowAboutUs = p.ShowAboutUs.Value;
            //if (p.ShowContactUs != null)
            //model.ShowContactus = p.ShowContactUs.Value;
            //if (p.ShowEvents != null)
            //model.ShowEvents = p.ShowEvents.Value;
            //if (p.ShowMission != null)
            //model.ShowMission = p.ShowMission.Value;
            //if (p.ShowNews != null)
            //model.ShowNews = p.ShowNews.Value;
            //if (p.ShowProduct != null)
            //model.ShowProducts = p.ShowProduct.Value;
            //if (p.ShowProject != null)
            //model.ShowProjects = p.ShowProject.Value;
            //if (p.ShowShowRooms != null)
            //model.ShowShowRooms = p.ShowShowRooms.Value;
            //if (p.ShowSlider != null)
            //model.ShowSlider = p.ShowSlider.Value;

            //if (p.ProjectMenu != null)
            //    model.ProjectMenu = p.ProjectMenu.Value;
            //if (p.ProductMenu != null)
            //    model.ProductMenu = p.ProductMenu.Value;
            //if (p.NewsMenu != null)
            //    model.NewsMenu = p.NewsMenu.Value;
            //if (p.MaterialMenu != null)
            //    model.MaterialsMenu = p.MaterialMenu.Value;
            //if (p.EventMenu != null)
            //    model.EventsMenu = p.EventMenu.Value;
            //if (p.GalleryMenu != null)
            //    model.GalleryMenu = p.GalleryMenu.Value;
            //if (p.ShowRoomsMenu != null)
            //    model.ShowRoomsMenu = p.ShowRoomsMenu.Value;

            AdminSetting(model);
            model.Latitude = p.Latitude;
                model.Longitude = p.Longitude;

            return View(model);
        }

        [HttpPost]
        [ValidateInput(false)]
        public ActionResult Index(SettingModel model,HttpPostedFileBase files,HttpPostedFileBase ProjFooter,HttpPostedFileBase ProdFooter,HttpPostedFileBase GFooter,HttpPostedFileBase EFooter ,HttpPostedFileBase MFooter ,HttpPostedFileBase WFooter)
        {
            if (ModelState.IsValid)
            {

                if (model.MainImage == null)
                {
                    if (String.IsNullOrEmpty(model.Photo))
                    {
                        AddToastMessage("Error", "Image are required", ToastType.Error);
                        return View(model);
                    }

                }

                Setting obj = context.Settings.Where(p => p.Id == 1).FirstOrDefault(); 
                var path = "";
                
                   
                obj.SMTP = model.SMTP;
                obj.UserName = model.UserName;
                obj.Password = model.Password;
                obj.Email = model.email;
                obj.GoogleAnalytic = model.GoogleAnalytic;
                obj.Authentication = model.Authentication;
                obj.GoogleURL = model.GoogleURL;
                obj.FaceBookURL = model.FacebookURL;
                obj.TwitterURL = model.TwitterURL;
                obj.YouTubeURL = model.YouTubeURL;
                obj.LinkedInURL = model.LinkedInURL;
                obj.Address = model.Address;
                //obj.ShowSlider = model.ShowSlider;
                //obj.ShowShowRooms = model.ShowShowRooms;
                //obj.ShowProject = model.ShowProjects;
                //obj.ShowProduct = model.ShowProducts;
                //obj.ShowNews = model.ShowNews;
                //obj.ShowMission = model.ShowMission;
                //obj.ShowEvents = model.ShowEvents;
                //obj.ShowContactUs = model.ShowContactus;
                //obj.ShowAboutUs = model.ShowAboutUs;
                //obj.ProductMenu = model.ProductMenu;
                //obj.ProjectMenu = model.ProjectMenu;
                //obj.GalleryMenu = model.GalleryMenu;
                //obj.EventMenu = model.EventsMenu;
                //obj.MaterialMenu = model.MaterialsMenu;
                //obj.ShowRoomsMenu = model.ShowRoomsMenu;
                //obj.NewsMenu = model.NewsMenu;
                obj.ArAddress = model.ArAddress;
                obj.EnCompanyName = model.ENCompanyName;
                obj.ArCompanyName = model.ArComapnyName;
                obj.CompanyPhone = Convert.ToInt32(model.CompanyPhone);
                obj.Latitude = model.Latitude;
                obj.Longitude = model.Longitude;
                obj.ShowHeaderImages = model.ShowHeaderIamges;
                obj.ShowFooterImages = model.ShowFooterIamges;
                if (model.MainImage != null && model.MainImage.ContentLength > 0)
                {
                    var Dstream = model.MainImage.InputStream;
                    var DfileName = Path.GetFileName(model.MainImage.FileName);
                    var DfilePath = string.Format("/Uploads/Setting/{0}", DfileName);
                    model.MainImage.SaveAs(Server.MapPath(DfilePath));
                    obj.Image = DfileName;
                }

                if (files != null && files.ContentLength > 0)
                {
                    var Dstream = files.InputStream;
                    var DfileName = Path.GetFileName(files.FileName);
                    var DfilePath = string.Format("/Uploads/Setting/{0}", DfileName);
                    files.SaveAs(Server.MapPath(DfilePath));
                    obj.Header_Photo = DfileName;
                }
                if (ProjFooter != null && ProjFooter.ContentLength > 0)
                {
                    var Dstream = ProjFooter.InputStream;
                    var DfileName = Path.GetFileName(ProjFooter.FileName);
                    var DfilePath = string.Format("/Uploads/Setting/{0}", DfileName);
                    ProjFooter.SaveAs(Server.MapPath(DfilePath));
                    obj.Project_Footer = DfileName;
                }
                if (ProdFooter != null && ProdFooter.ContentLength > 0)
                {
                    var Dstream = ProdFooter.InputStream;
                    var DfileName = Path.GetFileName(ProdFooter.FileName);
                    var DfilePath = string.Format("/Uploads/Setting/{0}", DfileName);
                    ProdFooter.SaveAs(Server.MapPath(DfilePath));
                    obj.Product_Footer = DfileName;
                }
                if (GFooter != null && GFooter.ContentLength > 0)
                {
                    var Dstream = GFooter.InputStream;
                    var DfileName = Path.GetFileName(GFooter.FileName);
                    var DfilePath = string.Format("/Uploads/Setting/{0}", DfileName);
                    GFooter.SaveAs(Server.MapPath(DfilePath));
                    obj.Gallery_Footer = DfileName;
                }
                if (EFooter != null && EFooter.ContentLength > 0)
                {
                    var Dstream = EFooter.InputStream;
                    var DfileName = Path.GetFileName(EFooter.FileName);
                    var DfilePath = string.Format("/Uploads/Setting/{0}", DfileName);
                    EFooter.SaveAs(Server.MapPath(DfilePath));
                    obj.Event_Footer = DfileName;
                }
                if (MFooter != null && MFooter.ContentLength > 0)
                {
                    var Dstream = MFooter.InputStream;
                    var DfileName = Path.GetFileName(MFooter.FileName);
                    var DfilePath = string.Format("/Uploads/Setting/{0}", DfileName);
                    MFooter.SaveAs(Server.MapPath(DfilePath));
                    obj.Material_Footer = DfileName;
                }
                if (WFooter != null && WFooter.ContentLength > 0)
                {
                    var Dstream = WFooter.InputStream;
                    var DfileName = Path.GetFileName(WFooter.FileName);
                    var DfilePath = string.Format("/Uploads/Setting/{0}", DfileName);
                    WFooter.SaveAs(Server.MapPath(DfilePath));
                    obj.Welcome_Footer = DfileName;
                }
                    context.SaveChanges();
                    TempData["Delete"] = "Delete";
                    this.AddToastMessage("Success", "Settings Added Successfully", ToastType.Success);
               
                
                return RedirectToAction("/Index");
            }
            var modelErrors = new List<string>();
            foreach (var modelState in ModelState.Values)
            {
                foreach (var modelError in modelState.Errors)
                {
                    modelErrors.Add(modelError.ErrorMessage);
                    AddToastMessage("Error", modelError.ErrorMessage, ToastType.Error);
                }
            }
            if (model.MainImage == null)
            {
                if (String.IsNullOrEmpty(model.Photo))
                {
                    AddToastMessage("Error", "Image are required", ToastType.Error);
                    modelErrors.Add("Image are required");
                }
            }

            if (files == null)
            {
                if (String.IsNullOrEmpty(model.headerImage))
                {
                    AddToastMessage("Error", "Image are required", ToastType.Error);
                    modelErrors.Add("Image are required");
                }
            }
            return View(model);
        }
    }
}