﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Web;
using System.Web.Mvc;
using NahrCms.DAL;
using NahrCms.Web.Areas.admin.DataModels.Models.FrameWorkModels;
using NahrCms.Web.Areas.admin.DataModels.Models.Projects;
using NahrCms.Web.Helpers.Notification;

namespace NahrCms.Web.Areas.admin.Controllers
{
    [Authorize]
    public class ProjectMangementController : BaseController
    {
        public ActionResult Index()
        {
            ProjectModel model = new ProjectModel();
            AdminSetting(model);
            LoadLookups(model);
            return View(model);
        }

        [HttpPost]
        public JsonResult Search(string Title, int? ProjectCategoryId, int jtStartIndex = 0, int jtPageSize = 20, string jtSorting = null)
        {
            var query = context.Projects.Where(p => (string.IsNullOrEmpty(Title)
                                                     || p.Title.ToLower().Contains(Title.ToLower())
                                                     ))
                                                     .Where(p =>
                                                     (!ProjectCategoryId.HasValue || p.ProjectCategory.Id == ProjectCategoryId))
                                                     .Select(p => new ProjectModel
                                                     {
                                                         Id = p.Id,
                                                         Title = p.Title,
                                                         ProjectCategory = p.ProjectCategory.Title
                                                     });
            var count = query.Count();
            List<ProjectModel> list = new List<ProjectModel>();
            if (jtSorting.Equals("Id ASC"))
            {
                list = query.OrderBy(item => item.Id).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }
            else if (jtSorting.Equals("Id DESC"))
            {
                list = query.OrderByDescending(item => item.Id).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }
            else if (jtSorting.Equals("Title ASC"))
            {
                list = query.OrderBy(item => item.Title).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }

            else if (jtSorting.Equals("Title DESC"))
            {
                list = query.OrderByDescending(item => item.Title).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }
            else if (jtSorting.Equals("ProjectCategory ASC"))
            {
                list = query.OrderBy(item => item.ProjectCategory).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }

            else if (jtSorting.Equals("ProjectCategory DESC"))
            {
                list = query.OrderByDescending(item => item.ProjectCategory).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }

            return Json(new { Result = "OK", Records = list, TotalRecordCount = count, JsonRequestBehavior.AllowGet });
        }

        public ActionResult AddEdit(int? id)
        {
            ProjectModel model = new ProjectModel();
           
            if (id.HasValue && id.Value > 0)
            {
                Setting obj = context.Settings.Where(x => x.Id == 1).FirstOrDefault();
                Project p = context.Projects.Where(d => d.Id == id).FirstOrDefault();
                model.Id = p.Id;
                model.Title = p.Title;
                model.TitleAr = p.TitleAr;
                model.Description = p.Description;
                model.DescriptionAr = p.DescriptionAr;
                model.YouTubeLink = p.YoutubeLink;
                model.ShortDescription = p.ShortDescription;
                model.ShortDescriptionAr = p.ShortDescriptionAr;
                model.MainPhoto = p.MainImage;
                model.ProjectCategoryId = p.CategoryId;
                model.Featured = p.Featured;
                model.Footer_Image = obj.Project_Footer;
                if (p.PhotoGallery != null)
                    model.PhotosUpload = p.PhotoGallery.Split(',').ToList();
               
                LoadLookups(model);
            }
            else
            {
                model = new ProjectModel();
                AdminSetting(model);
                LoadLookups(model);
            }
            AdminSetting(model);
            LoadLookups(model);
            return View(model);
        }

        [HttpPost]
        public ActionResult AddEdit(ProjectModel model)
        {

            if (ModelState.IsValid)
            {

                if (model.MainImage == null)
                {
                    if (String.IsNullOrEmpty(model.MainPhoto))
                    {
                        AddToastMessage("Error", "Image are required", ToastType.Error);
                        LoadLookups(model);
                        return View(model);
                    }

                }

                Project obj = null;
                var path = "";
                if (model.Id > 0)
                {
                    obj = context.Projects.Where(p => p.Id == model.Id).FirstOrDefault();
                }
                else
                    obj = new Project();
                obj.Title = model.Title;
               // obj.TitleAr = model.TitleAr;
                obj.Description = model.Description;
               // obj.DescriptionAr = model.DescriptionAr;
                obj.YoutubeLink = model.YouTubeLink;
                obj.ShortDescription = model.ShortDescription;
               // obj.ShortDescriptionAr = model.ShortDescriptionAr;
                obj.Featured = model.Featured;
                if (model.ProjectCategoryId.HasValue)
                    obj.CategoryId = model.ProjectCategoryId;
                if (model.MainImage != null && model.MainImage.ContentLength > 0)
                {
                    var Dstream = model.MainImage.InputStream;
                    var DfileName = Path.GetFileName(model.MainImage.FileName);
                    var DfilePath = string.Format("/Uploads/Project/{0}", DfileName);
                    model.MainImage.SaveAs(Server.MapPath(DfilePath));
                    obj.MainImage = DfileName;
                }
              

                if (obj.Id == 0)
                {
                    context.Projects.Add(obj);
                    context.SaveChanges();
                    TempData["Delete"] = "Delete";
                    this.AddToastMessage("Success", "Project Added Successfully", ToastType.Success);
                    return RedirectToAction("AddEdit", new { id = obj.Id });
                }
                else
                {
                    context.SaveChanges();
                    this.AddToastMessage("Success", "Project Edited Successfully", ToastType.Success);
                }

                return RedirectToAction("/Index");
            }
            var modelErrors = new List<string>();
            foreach (var modelState in ModelState.Values)
            {
                foreach (var modelError in modelState.Errors)
                {
                    modelErrors.Add(modelError.ErrorMessage);
                }
            }
            AddToastMessage("Error", string.Join("<br />", modelErrors.ToArray()), ToastType.Error);
            LoadLookups(model);
            return View(model);
        }


        [HttpPost]
        public ActionResult AddEditAr(ProjectModel model)
        {
            Project obj = context.Projects.Where(p => p.Id == model.Id).FirstOrDefault();

            obj.TitleAr = model.TitleAr;
            obj.DescriptionAr = model.DescriptionAr;
            obj.ShortDescriptionAr = model.ShortDescriptionAr;

            context.SaveChanges();
            AddToastMessage("Error", "Product updated successfully", ToastType.Success);
            return RedirectToAction("/Index");
        }
        [HttpPost]
        public ActionResult EditPhotoGallary(ProjectModel model, IEnumerable<HttpPostedFileBase> files)
        {
            Project obj = context.Projects.Where(p => p.Id == model.Id).FirstOrDefault();
            string Images = "";
            if (files != null)
            {
                foreach (HttpPostedFileBase file in files)
                {
                    var fileName = Path.GetFileName(file.FileName);
                    var filePath = string.Format("/Uploads/Project/{0}", fileName);
                    file.SaveAs(Server.MapPath(filePath));
                    if (Images == "")
                    {
                        Images = fileName;
                    }
                    else
                    {
                        Images = Images + "," + fileName;
                    }
                }
            }
            if (obj.PhotoGallery == null || obj.PhotoGallery == "")
                obj.PhotoGallery = Images;
            else
                obj.PhotoGallery = obj.PhotoGallery + "," + Images;

            context.SaveChanges();
            AddToastMessage("Error", "Project updated successfully", ToastType.Success);
            return RedirectToAction("/Index");
        }
        public ActionResult Delete(int id)
        {
            var obj = context.Projects.Find(id);
            context.Projects.Remove(obj);
            context.SaveChanges();
            return Json(new { Result = true, data = obj }, JsonRequestBehavior.AllowGet);

        }

        public ActionResult DeletePhoto(int Id, int Index)
        {
            var obj = context.Projects.SingleOrDefault(f => f.Id == Id);
            var Photos = obj.PhotoGallery.Split(',').ToList();
            Photos.RemoveAt(Index);
            string Images = "";
            foreach (var item in Photos)
            {
                if (Images == "")
                {
                    Images = item;
                }
                else
                {
                    Images = Images + "," + item;
                }
            }
            obj.PhotoGallery = Images;
            context.SaveChanges();
            TempData["Delete"] = "Delete";
            return RedirectToAction("AddEdit", "ProjectMangement", new { Id = Id });
        }

        static string ConvertStringArrayToString(string[] array)
        {
            //
            // Concatenate all the elements into a StringBuilder.
            //
            StringBuilder builder = new StringBuilder();
            foreach (string value in array)
            {
                if (value != "")
                    builder.Append(value);
                builder.Append(',');
            }
            return builder.ToString();
        }
        private void LoadLookups(ProjectModel model)
        {

            var relatedProjectCategory = from c in context.ProjectCategories.ToList()
                                         select new BaseObject() { Id = c.Id, Name = c.Title };
            model.ProjectCategoryList = new List<BaseObject>();
            model.ProjectCategoryList.Add(new BaseObject() { Id = null, Name = "Select Project Category" });
            model.ProjectCategoryList.AddRange(relatedProjectCategory.ToList());

        }
    }
}