﻿using System.Collections.Generic;
using System.Linq;
using System.Web.Mvc;
using NahrCms.DAL;
using NahrCms.Web.Areas.admin.DataModels.Models.Projects;
using NahrCms.Web.Helpers.Notification;

namespace NahrCms.Web.Areas.admin.Controllers
{
    [Authorize]
    public class ProjectCategoryMangementController : BaseController
    {
        public ActionResult Index()
        {
            ProjectCategoryModel model = new ProjectCategoryModel();
            AdminSetting(model);
            return View(model);
        }
        [HttpPost]
        public JsonResult Search(string Title, int jtStartIndex = 0, int jtPageSize = 20, string jtSorting = null)
        {
            var query = context.ProjectCategories.Where(p => (string.IsNullOrEmpty(Title)
                                                     || p.Title.ToLower().Contains(Title.ToLower()))).
                                                     Select(p => new ProjectCategoryModel
                                                     {
                                                         Id = p.Id,
                                                         Title = p.Title
                                                     }); ;
            var count = query.Count();
            List<ProjectCategoryModel> list = new List<ProjectCategoryModel>();
            if (jtSorting.Equals("Id ASC"))
            {
                list = query.OrderBy(item => item.Id).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }
            else if (jtSorting.Equals("Id DESC"))
            {
                list = query.OrderByDescending(item => item.Id).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }
            else if (jtSorting.Equals("Title ASC"))
            {
                list = query.OrderBy(item => item.Title).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }

            else if (jtSorting.Equals("Title DESC"))
            {
                list = query.OrderByDescending(item => item.Title).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }

            return Json(new { Result = "OK", Records = list, TotalRecordCount = count });
        }
        [HttpPost]
        public ActionResult AddEditAr(ProjectCategoryModel model)
        {
            ProjectCategory obj = context.ProjectCategories.Where(p => p.Id == model.Id).FirstOrDefault();

            obj.TitleAr = model.TitleAr;
           

            context.SaveChanges();
            AddToastMessage("Error", "Product updated successfully", ToastType.Success);
            return RedirectToAction("/Index");
        }
        public ActionResult AddEdit(int? Id)
        {
            ProjectCategoryModel model = new ProjectCategoryModel();
            AdminSetting(model);
           
            if (Id.HasValue && Id.Value > 0)
            {
                ProjectCategory p = context.ProjectCategories.Where(x => x.Id == Id.Value).FirstOrDefault();

                model.Id = p.Id;
                model.Title = p.Title;
                model.TitleAr = p.TitleAr;
                

            }
           
            return View(model);
        }
        [HttpPost]
        public ActionResult AddEdit(ProjectCategoryModel model)
        {
            if (ModelState.IsValid)
            {
                ProjectCategory obj = null;
                if (model.Id > 0)
                {
                    obj = context.ProjectCategories.Where(p => p.Id == model.Id).FirstOrDefault();
                }
                else
                    obj = new ProjectCategory();
                obj.Title = model.Title;
              //  obj.TitleAr = model.TitleAr;

                if (obj.Id == 0)
                {
                    context.ProjectCategories.Add(obj);
                    context.SaveChanges();
                    this.AddToastMessage("Success", "Project Category Added Successfully", ToastType.Success);
                }
                else
                {
                    context.SaveChanges();
                    this.AddToastMessage("Success", "Project Category Edited Successfully", ToastType.Success);
                }

                return RedirectToAction("/Index");
            }
            AddToastMessage("Error", "Check Your from", ToastType.Error);
            return View(model);
        }
        public ActionResult Delete(int id)
        {
            var obj = context.ProjectCategories.Find(id);
            context.ProjectCategories.Remove(obj);
            context.SaveChanges();
            return Json(new { Result = true, data = obj }, JsonRequestBehavior.AllowGet);

        }
    }
}