﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Web;
using System.Web.Mvc;
using NahrCms.DAL;
using NahrCms.Web.Areas.admin.DataModels.Models.FrameWorkModels;
using NahrCms.Web.Areas.admin.DataModels.Models.Products;
using NahrCms.Web.Helpers;
using NahrCms.Web.Helpers.Notification;
using NahrCms.Web.Models;

namespace NahrCms.Web.Areas.admin.Controllers
{
    [Authorize]
    public class ProductMangementController : BaseController
    {
        public ActionResult Index()
        {
            ProductModel model = new ProductModel();
            AdminSetting(model);
            return View(model);
        }
        [HttpPost]
        public JsonResult Search(string Title, int jtStartIndex = 0, int jtPageSize = 20, string jtSorting = null)
        {
            var query = context.Products.Where(p => (string.IsNullOrEmpty(Title)
                                                     || p.Title.ToLower().Contains(Title.ToLower()))).Select(p => new ProductModel
                                                     {
                                                         Id = p.Id,
                                                         Title = p.Title,
                                                         ProductCategory = p.ProductCategory.Title
                                                     });
            var count = query.Count();
            List<ProductModel> list = new List<ProductModel>();
            if (jtSorting.Equals("Id ASC"))
            {
                list = query.OrderBy(item => item.Id).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }
            else if (jtSorting.Equals("Id DESC"))
            {
                list = query.OrderByDescending(item => item.Id).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }
            else if (jtSorting.Equals("Title ASC"))
            {
                list = query.OrderBy(item => item.Title).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }

            else if (jtSorting.Equals("Title DESC"))
            {
                list = query.OrderByDescending(item => item.Title).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }
            else if (jtSorting.Equals("ProductCategory ASC"))
            {
                list = query.OrderBy(item => item.ProductCategory).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }

            else if (jtSorting.Equals("ProductCategory DESC"))
            {
                list = query.OrderByDescending(item => item.ProductCategory).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }

            return Json(new { Result = "OK", Records = list, TotalRecordCount = count, JsonRequestBehavior.AllowGet });
        }
        public ActionResult AddEdit(int? id)
        {
            ProductModel model = new ProductModel();
            
            if (id.HasValue && id.Value > 0)
            {
                Product p = context.Products.Where(d => d.Id == id).FirstOrDefault();
                model.Id = p.Id;
                model.Title = p.Title;
                model.TitleFr = p.TitleFr;
                model.TitleNl = p.TitleNl;
                model.Description = p.Description;
                model.DescriptionFr = p.DescriptionFr;
                model.DescriptionNl = p.DescriptionNl;
                model.ShortDescription =  p.ShortDescription;
                model.ShortDescriptionFr =  p.ShortDescriptionFr;
                model.ShortDescriptionNl =  p.ShortDescriptionNl;
                model.MainPhoto = p.MainImage;
                model.ProductCategoryId = p.CategoryId;
                model.Featured = p.Featured;
                if (p.PhotoGallery != null)
                    model.PhotosUpload = p.PhotoGallery.Split(',').ToList();
                AdminSetting(model);
                LoadLookups(model);
                return View(model);
            }
            else
            {
                model = new ProductModel();
                AdminSetting(model);
                LoadLookups(model);
                return View(model);
            }
        }
        [HttpPost]
        public ActionResult AddEdit(ProductModel model, IEnumerable<HttpPostedFileBase> files, string[] SelectedProducts)
        {
            var relatedProducts = context.Products.ToList();
            if (ModelState.IsValid)
            {

                if (model.MainImage == null)
                {
                    if (String.IsNullOrEmpty(model.MainPhoto))
                    {
                        AddToastMessage("Error", "Image are required", ToastType.Error);
                        LoadLookups(model);
                        return View(model);
                    }

                }

                Product obj = null;
                var path = "";
                if (model.Id > 0)
                {
                    obj = context.Products.Where(p => p.Id == model.Id).FirstOrDefault();
                }
                else
                    obj = new Product();
                obj.Title = model.Title ;
                  obj.TitleFr = model.TitleFr;
                  obj.TitleNl = model.TitleNl;
                obj.Description = model.Description;
                 obj.DescriptionFr = model.DescriptionFr;
                 obj.DescriptionNl = model.DescriptionNl;
                obj.ShortDescription = model.ShortDescription;
                 obj.ShortDescriptionFr = model.ShortDescriptionFr;
                 obj.ShortDescriptionNl = model.ShortDescriptionNl;
                obj.Featured = model.Featured;
                if (model.ProductCategoryId.HasValue)
                    obj.CategoryId = model.ProductCategoryId;

                if (model.MainImage != null && model.MainImage.ContentLength > 0)
                {
                    var Dstream = model.MainImage.InputStream;
                    var DfileName = Path.GetFileName(model.MainImage.FileName);
                    var DfilePath = string.Format("/Uploads/Product/{0}", DfileName);
                    model.MainImage.SaveAs(Server.MapPath(DfilePath));
                    obj.MainImage = DfileName;
                }
                if (obj.Id == 0)
                {
                    context.Products.Add(obj);
                    context.SaveChanges();
                    TempData["Delete"] = "Delete";
                    this.AddToastMessage("Success", "Product Added Successfully", ToastType.Success);
                    return RedirectToAction("AddEdit", new { id = obj.Id });
                }
                else
                {
                    context.SaveChanges();
                    this.AddToastMessage("Success", "Product Edited Successfully", ToastType.Success);
                }

                //return RedirectToAction("AddEdit", new { id = obj.Id });
                return RedirectToAction("/Index");
            }

            var modelErrors = new List<string>();
            foreach (var modelState in ModelState.Values)
            {
                foreach (var modelError in modelState.Errors)
                {
                    modelErrors.Add(modelError.ErrorMessage);
                }
            }
            AddToastMessage("Error", string.Join("<br />", modelErrors.ToArray()), ToastType.Error);
            LoadLookups(model);
            AdminSetting(model);
            return View(model);
        }
        [HttpPost]
        public ActionResult EditPhotoGallary(ProductModel model, IEnumerable<HttpPostedFileBase> files)
        {
            Product obj = context.Products.Where(p => p.Id == model.Id).FirstOrDefault();
            string Images = "";
            if (files != null)
            {
                foreach (HttpPostedFileBase file in files)
                {
                    var fileName = Path.GetFileName(file.FileName);
                    var filePath = string.Format("/Uploads/Product/{0}", fileName);
                    file.SaveAs(Server.MapPath(filePath));
                    if (Images == "")
                    {
                        Images = fileName;
                    }
                    else
                    {
                        Images = Images + "," + fileName;
                    }
                }
            }
            if (obj.PhotoGallery == null || obj.PhotoGallery == "")
                obj.PhotoGallery = Images;
            else
                obj.PhotoGallery = obj.PhotoGallery + "," + Images;

            context.SaveChanges();
            AddToastMessage("Success", "Product updated successfully", ToastType.Success);
            return RedirectToAction("/Index");
        }

        [HttpPost]
        public ActionResult AddEditFr(ProductModel model)
        {
            Product obj = context.Products.Where(p => p.Id == model.Id).FirstOrDefault();

             obj.TitleFr = model.TitleFr;
              obj.DescriptionFr = model.DescriptionFr;
             obj.ShortDescriptionFr = model.ShortDescriptionFr;

            context.SaveChanges();
            AddToastMessage("Success", "Product updated successfully", ToastType.Success);
            return RedirectToAction("/Index");
        }
        [HttpPost]
        public ActionResult AddEditNl(ProductModel model)
        {
            Product obj = context.Products.Where(p => p.Id == model.Id).FirstOrDefault();

            obj.TitleNl = model.TitleNl;
            obj.DescriptionNl = model.DescriptionNl;
            obj.ShortDescriptionNl = model.ShortDescriptionNl;

            context.SaveChanges();
            AddToastMessage("Success", "Product updated successfully", ToastType.Success);
            return RedirectToAction("/Index");
        }
        public ActionResult Delete(int id)
        {
            var obj = context.Products.Find(id);
            context.Products.Remove(obj);
            context.SaveChanges();
            return Json(new { Result = true, data = obj }, JsonRequestBehavior.AllowGet);

        }
        public ActionResult DeletePhoto(int Id, int Index)
        {
            var obj = context.Products.SingleOrDefault(f => f.Id == Id);
            var Photos = obj.PhotoGallery.Split(',').ToList();
            Photos.RemoveAt(Index);
            string Images = "";
            foreach (var item in Photos)
            {
                if (Images == "")
                {
                    Images = item;
                }
                else
                {
                    Images = Images + "," + item;
                }
            }
            obj.PhotoGallery = Images;
            context.SaveChanges();
            TempData["Delete"] = "Delete";
            return RedirectToAction("AddEdit", "ProductMangement", new { Id = Id });
        }
        static string ConvertStringArrayToString(string[] array)
        {
            //
            // Concatenate all the elements into a StringBuilder.
            //
            StringBuilder builder = new StringBuilder();
            foreach (string value in array)
            {
                if (value != "")
                    builder.Append(value);
                builder.Append(',');
            }
            return builder.ToString();
        }
        private void LoadLookups(ProductModel model)
        {
            var relatedProjectCategory = from c in context.ProductCategories.ToList()
                                         select new BaseObject() { Id = c.Id, Name = c.Title };
            model.ProductCategoryList = new List<BaseObject>();
            model.ProductCategoryList.Add(new BaseObject() { Id = -1, Name = "Select Product Category" });
            model.ProductCategoryList.AddRange(relatedProjectCategory.ToList());

        }
    }
}