﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using NahrCms.DAL;
using NahrCms.Web.Areas.admin.DataModels.Models.Products;
using NahrCms.Web.Helpers.Notification;
using NahrCms.Web.Areas.admin.DataModels.Models.FrameWorkModels;
using NahrCms.Web.Helpers;
using NahrCms.Web.Models;

namespace NahrCms.Web.Areas.admin.Controllers
{
    [Authorize]
    public class ProductCategoryMangementController : BaseController
    {
        public ActionResult Index()
        {
            ProductCategoryModel model = new ProductCategoryModel();
            AdminSetting(model);
            return View(model);
        }
        [HttpPost]
        public JsonResult Search(string Title, int jtStartIndex = 0, int jtPageSize = 20, string jtSorting = null)
        {
            var query = context.ProductCategories.Where(p => (string.IsNullOrEmpty(Title)
                                                     || p.Title.ToLower().Contains(Title.ToLower()))).
                                                     Select(p => new ProductCategoryModel
                                                     {
                                                         Id = p.Id,
                                                         Title = p.Title
                                                     }); ;
            var count = query.Count();
            List<ProductCategoryModel> list = new List<ProductCategoryModel>();
            if (jtSorting.Equals("Id ASC"))
            {
                list = query.OrderBy(item => item.Id).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }
            else if (jtSorting.Equals("Id DESC"))
            {
                list = query.OrderByDescending(item => item.Id).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }
            else if (jtSorting.Equals("Title ASC"))
            {
                list = query.OrderBy(item => item.Title).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }

            else if (jtSorting.Equals("Title DESC"))
            {
                list = query.OrderByDescending(item => item.Title).Skip(jtStartIndex).Take(jtPageSize).ToList();
            }

            return Json(new { Result = "OK", Records = list, TotalRecordCount = count });
        }
        public ActionResult AddEdit(int? Id)
        {
            ProductCategoryModel model = new ProductCategoryModel();
           

            if (Id.HasValue && Id.Value > 0)
            {
               ProductCategory p  = context.ProductCategories.Where(x => x.Id == Id.Value).FirstOrDefault();

                model.Id = p.Id;
                model.Title = p.Title;
                model.TitleFr = p.TitleFr;
                model.TitleNl = p.TitleNl;
                model.Description = p.Description;
                model.DescriptionFr = p.DescriptionFr;
                model.DescriptionNl = p.DescriptionNl;
                model.MainPhoto = p.Image;
                model.ParentId = p.ParentId.Value;
                   
           
               
            }
           
            AdminSetting(model);
            LoadLookups(model);
            return View(model);
        }

        [HttpPost]
        public ActionResult AddEditFr(ProductCategoryModel model)
        {
            ProductCategory obj = context.ProductCategories.Where(p => p.Id == model.Id).FirstOrDefault();

            obj.TitleFr = model.TitleFr;
            obj.DescriptionFr = model.DescriptionFr;
           

            context.SaveChanges();
            AddToastMessage("Error", "Product updated successfully", ToastType.Success);
            return RedirectToAction("/Index");
        }
        [HttpPost]
        public ActionResult AddEditNl(ProductCategoryModel model)
        {
            ProductCategory obj = context.ProductCategories.Where(p => p.Id == model.Id).FirstOrDefault();

            obj.TitleNl = model.TitleNl;
            obj.DescriptionNl = model.DescriptionNl;


            context.SaveChanges();
            AddToastMessage("Error", "Product updated successfully", ToastType.Success);
            return RedirectToAction("/Index");
        }
        [HttpPost]
        public ActionResult AddEdit(ProductCategoryModel model, IEnumerable<HttpPostedFileBase> files)
        { 
            if (ModelState.IsValid)
            {
                if (model.MainImage == null)
                {
                    if (String.IsNullOrEmpty(model.MainPhoto))
                    {
                        AddToastMessage("Error", "Image are required", ToastType.Error);
                        LoadLookups(model);
                        return View(model);
                    }

                }
                ProductCategory obj = null;
                if (model.Id > 0)
                {
                    obj = context.ProductCategories.Where(p => p.Id == model.Id).FirstOrDefault();
                }
                else
                    obj = new ProductCategory();
                obj.Title = model.Title;
                obj.TitleFr = model.TitleFr;
                obj.TitleNl = model.TitleNl;
                obj.Description = model.Description;
                obj.DescriptionFr = model.DescriptionFr;
                obj.DescriptionNl = model.DescriptionNl;
                if (model.ParentId.HasValue)
                {
                    if (model.ParentId == -1)
                    {
                        obj.ParentId = 0;

                    }
                    else
                    {
                        obj.ParentId = model.ParentId;
                        ProductCategory p = context.ProductCategories.Where(x => x.Id == model.ParentId).FirstOrDefault();
                        if (p != null)
                        {
                            if (p.ChildList != null)
                            {
                                IList<string> childlist = p.ChildList.Split(',').ToList();
                                if (!childlist.Contains(model.Title))
                                {
                                    foreach (var item in childlist)
                                    {

                                        if (p.ChildList == null)
                                            p.ChildList = model.Title;
                                        else
                                            p.ChildList = p.ChildList + "," + model.Title;

                                    }
                                }
                            }
                            else
                            {
                                p.ChildList = model.Title; 
                            }

                        }
                    }
                }


                if (model.MainImage != null && model.MainImage.ContentLength > 0)
                {
                    var Dstream = model.MainImage.InputStream;
                    var DfileName = Path.GetFileName(model.MainImage.FileName);
                    var DfilePath = string.Format("/Uploads/ProductCategory/{0}", DfileName);
                    model.MainImage.SaveAs(Server.MapPath(DfilePath));
                    obj.Image = DfileName;
                }
                if (obj.Id == 0)
                {
                    context.ProductCategories.Add(obj);
                    context.SaveChanges();
                    this.AddToastMessage("Success", "Product Category Added Successfully", ToastType.Success);
                }
                else
                {
                    context.SaveChanges();
                    this.AddToastMessage("Success", "Product Category Edited Successfully", ToastType.Success);
                }

                return RedirectToAction("/Index");
            }

            AdminSetting(model);
            LoadLookups(model);
            var modelErrors = new List<string>();
            foreach (var modelState in ModelState.Values)
            {
                foreach (var modelError in modelState.Errors)
                {
                    modelErrors.Add(modelError.ErrorMessage);
                }
            }
            AddToastMessage("Error", string.Join("<br />", modelErrors.ToArray()), ToastType.Error);
            return View(model);
        }
        public ActionResult Delete(int id)
        {
            var obj = context.ProductCategories.Find(id);
            context.ProductCategories.Remove(obj);
            context.SaveChanges();
            return Json(new { Result = true, data = obj }, JsonRequestBehavior.AllowGet);

        }
        private void LoadLookups(ProductCategoryModel model)
        {
            var relatedProjectCategory = from c in context.ProductCategories.ToList()
                                         select new BaseObject() { Id = c.Id, Name = c.Title };
            model.ProductCategoryList = new List<BaseObject>();
            model.ProductCategoryList.Add(new BaseObject() { Id = -1, Name = "No Parent" });
            model.ProductCategoryList.AddRange(relatedProjectCategory.ToList());

        }
    }
}